/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.objectteams.otdt.internal.ui.OTDTUIMessages;
import org.eclipse.objectteams.otdt.internal.ui.compare.BaseMethodCompareElement;
import org.eclipse.objectteams.otdt.internal.ui.compare.RoleMethodNode;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class CompareBoundMethodsEditorInput
extends SaveableCompareEditorInput {
    private ITypedElement left;
    private IMethod roleMethod;
    private BaseMethodCompareElement right;
    CompareInputChangeNotifier notifier = new CompareInputChangeNotifier(){

        protected IResource[] getResources(ICompareInput input) {
            IResource resource = CompareBoundMethodsEditorInput.this.getResource();
            if (resource == null) {
                return new IResource[0];
            }
            return new IResource[]{resource};
        }
    };
    EditableSharedDocumentAdapter sharedDocumentAdapter;
    private Composite outline;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CompareBoundMethodsEditorInput) {
            CompareBoundMethodsEditorInput other = (CompareBoundMethodsEditorInput)((Object)obj);
            return other.left.equals(this.left) && ((Object)((Object)other.right)).equals((Object)this.right);
        }
        return false;
    }

    public CompareBoundMethodsEditorInput(IMethod roleMethod, IMethod baseMethod, IWorkbenchPage page) throws CoreException {
        super(new CompareConfiguration(), page);
        this.roleMethod = roleMethod;
        this.left = this.makeJavaNode();
        this.right = new BaseMethodCompareElement(baseMethod, this.getEncoding(roleMethod));
        this.setTitle(this.left.getName());
    }

    private ITypedElement makeJavaNode() throws CoreException {
        MyJavaStructureCreator creator = new MyJavaStructureCreator();
        IStructureComparator rootNode = creator.createStructure((Object)this, null);
        ISourceRange sourceRange = this.roleMethod.getSourceRange();
        return new RoleMethodNode((RoleMethodNode)rootNode, 11, this.roleMethod.getElementName(), sourceRange.getOffset(), sourceRange.getLength());
    }

    private String getEncoding(IMethod method) {
        IResource resource = method.getResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                return file.getCharset();
            }
            catch (CoreException e) {
                OTDTUIPlugin.log(e);
            }
        }
        return null;
    }

    public Control createOutlineContents(Composite parent, int direction) {
        this.outline = (Composite)super.createOutlineContents(parent, direction);
        return this.outline;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.createCompareInput();
        this.getCompareConfiguration().setLeftEditable(true);
        this.getCompareConfiguration().setRightEditable(false);
        CompareBoundMethodsEditorInput.ensureContentsCached(this.right, monitor);
        this.initLabels(input);
        return input;
    }

    private static void ensureContentsCached(BaseMethodCompareElement right, IProgressMonitor monitor) {
        if (right != null) {
            try {
                right.cacheContents(monitor);
            }
            catch (CoreException e) {
                OTDTUIPlugin.log(e);
            }
        }
    }

    private IResource getResource() {
        return this.roleMethod.getResource();
    }

    private ICompareInput createCompareInput() {
        MyDiffNode input = new MyDiffNode(this.left, (ITypedElement)this.right);
        return input;
    }

    private void initLabels(ICompareInput input) {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.left != null) {
            String leftLabel = NLS.bind((String)OTDTUIMessages.CompareBoundMethods_role_method_label, (Object[])new Object[]{this.roleMethod.getDeclaringType().getElementName(), this.roleMethod.getElementName()});
            cc.setLeftLabel(leftLabel);
        }
        if (this.right != null) {
            String rightLabel = NLS.bind((String)OTDTUIMessages.CompareBoundMethods_base_method_label, (Object[])new Object[]{this.right.getTypeName(), this.right.getName()});
            cc.setRightLabel(rightLabel);
        }
    }

    public String getToolTipText() {
        Object[] titleObject = new Object[]{this.left.getName(), this.right.getName()};
        return NLS.bind((String)OTDTUIMessages.CompareBoundMethods_compare_tooltip, (Object[])titleObject);
    }

    public String getTitle() {
        Object[] titleObject = new Object[]{this.left.getName()};
        return NLS.bind((String)OTDTUIMessages.CompareBoundMethods_compare_title, (Object[])titleObject);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class || adapter == IResource.class) {
            return this.getResource();
        }
        if (adapter == ISharedDocumentAdapter.class) {
            return this.getSharedDocumentAdapter();
        }
        return super.getAdapter(adapter);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                }

                public void handleDocumentFlushed() {
                    IEditorInput input = CompareBoundMethodsEditorInput.this.sharedDocumentAdapter.getDocumentKey((Object)CompareBoundMethodsEditorInput.this.getResource());
                    try {
                        if (input != null) {
                            CompareBoundMethodsEditorInput.this.sharedDocumentAdapter.saveDocument(input, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException e) {
                        OTDTUIPlugin.log(e);
                    }
                }

                public void handleDocumentDeleted() {
                }

                public void handleDocumentSaved() {
                }

                public void handleDocumentDisconnected() {
                }
            });
        }
        return this.sharedDocumentAdapter;
    }

    protected void fireInputChange() {
        ((MyDiffNode)((Object)this.getCompareResult())).fireChange();
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.outline.setVisible(false);
        this.notifier.initialize();
    }

    protected void handleDispose() {
        super.handleDispose();
        this.notifier.dispose();
        IEditorInput input = this.sharedDocumentAdapter.getDocumentKey((Object)this.getResource());
        if (input != null) {
            this.sharedDocumentAdapter.disconnect((Object)input);
        }
    }

    public class MyDiffNode
    extends AbstractCompareInput {
        public MyDiffNode(ITypedElement left, ITypedElement right) {
            super(3, null, left, right);
        }

        public void fireChange() {
            super.fireChange();
        }

        protected CompareInputChangeNotifier getChangeNotifier() {
            return CompareBoundMethodsEditorInput.this.notifier;
        }

        public boolean needsUpdate() {
            return false;
        }

        public void update() {
            this.fireChange();
        }
    }

    class MyJavaStructureCreator
    extends JavaStructureCreator {
        MyJavaStructureCreator() {
        }

        protected IStructureComparator createStructureComparator(Object element, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
            if (document != null) {
                return new RoleMethodNode.RootJavaNode(document, element, sharedDocumentAdapter);
            }
            return null;
        }
    }
}

