/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.discovery.core.annotations.ParameterInitialValue;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.AbstractDiscoverJavaModelFromProject;
import org.eclipse.modisco.java.discoverer.ElementsToAnalyze;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJavaModelFromProject
extends AbstractDiscoverJavaModelFromProject<IProject> {
    public static final String ID = "org.eclipse.modisco.java.discoverer.project";

    public boolean isApplicableTo(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            return false;
        }
    }

    protected void basicDiscoverElement(IProject project, IProgressMonitor monitor) throws DiscoveryException {
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                this.analyzeJavaProject(javaProject, monitor);
            }
        }
        catch (CoreException e) {
            throw new DiscoveryException("Error discovering Java project", (Throwable)e);
        }
    }

    @ParameterInitialValue(name="ELEMENTS_TO_ANALYZE")
    public static ElementsToAnalyze getElementsToAnalyzeInitialValue(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                return new ElementsToAnalyze(javaProject);
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
        return null;
    }
}

