/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Renderer(target="html")
public class HtmlOutputter
implements IOutputter {
    private int maxLinkObjects = 10;
    private static final boolean useList = true;

    @Override
    public void embedd(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        boolean hasDetailsLink;
        boolean bl = hasDetailsLink = "true".equals(context.param("html.render_details", "true")) && result != null && result.getResultMetaData() != null && !result.getResultMetaData().getDetailResultProviders().isEmpty();
        if (result instanceof RefinedTable) {
            this.renderTable(context, (RefinedTable)result, writer, hasDetailsLink);
        } else if (result instanceof RefinedTree) {
            this.renderTree(context, (RefinedTree)result, writer, hasDetailsLink);
        } else if (result instanceof TextResult) {
            this.renderText(context, (TextResult)result, writer, hasDetailsLink);
        } else if (result instanceof DisplayFileResult) {
            File dest;
            File src = ((DisplayFileResult)result).getFile();
            if (!src.renameTo(dest = new File(context.getOutputDirectory(), src.getName()))) {
                throw new IOException(MessageUtil.format(Messages.HtmlOutputter_Error_MovingFile, src.getAbsolutePath(), dest.getAbsolutePath()));
            }
        } else if (result == null) {
            writer.append(Messages.HtmlOutputter_Label_NotApplicable);
        } else {
            writer.append(result.toString());
        }
    }

    @Override
    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        throw new UnsupportedOperationException(result.toString());
    }

    private String altText(URL url) {
        String alt = "";
        return HTMLUtils.escapeText(alt);
    }

    private void renderTable(IOutputter.Context context, RefinedTable table, Writer artefact, boolean hasDetailsLink) throws IOException {
        Column[] columns = table.getColumns();
        artefact.append("<table class=\"result\">");
        this.renderTableHeader(context, artefact, columns, hasDetailsLink);
        artefact.append("<tbody>");
        this.renderFilterRow(context, artefact, table, hasDetailsLink);
        int numberOfRowsToDisplay = context.hasLimit() && context.getLimit() < table.getRowCount() ? context.getLimit() : table.getRowCount();
        int rowIndex = 0;
        while (rowIndex < numberOfRowsToDisplay) {
            Object row = table.getRow(rowIndex);
            artefact.append("<tr");
            if (table.isSelected(row)) {
                artefact.append(" class=\"selected\"");
            }
            artefact.append(">");
            if (context.isColumnVisible(0)) {
                artefact.append("<td>");
                URL url = table.getIcon(row);
                String iconUrl = context.addIcon(url);
                if (iconUrl != null) {
                    String alt = this.altText(url);
                    artefact.append("<img src=\"").append(iconUrl).append("\" alt=\"" + alt + "\">");
                }
                this.renderColumnValue(context, artefact, table, columns, row, 0);
                artefact.append("</td>");
            }
            this.renderDataColumns(context, artefact, table, columns, row, hasDetailsLink);
            artefact.append("</tr>");
            ++rowIndex;
        }
        TotalsRow totalsRow = table.buildTotalsRow(table.getRows());
        totalsRow.setVisibleItems(numberOfRowsToDisplay);
        if (totalsRow.isVisible()) {
            this.renderTotalsRow(context, artefact, table, table.getRows(), totalsRow, columns, new int[0], hasDetailsLink);
        }
        artefact.append("</tbody></table>");
    }

    private void renderFilterRow(IOutputter.Context context, Writer artefact, RefinedStructuredResult result, boolean hasDetailsLink) throws IOException {
        if (!result.hasActiveFilter()) {
            return;
        }
        artefact.append("<tr class=\"filter\">");
        Filter[] filter = result.getFilter();
        int i = 0;
        while (i < filter.length) {
            if (context.isColumnVisible(i)) {
                if (filter[i].isActive()) {
                    artefact.append("<td>").append(HTMLUtils.escapeText(filter[i].getCriteria())).append("</td>");
                } else {
                    artefact.append("<td/>");
                }
            }
            ++i;
        }
        if (hasDetailsLink) {
            artefact.append("<td/>");
        }
        artefact.append("</tr>");
    }

    private void renderTableHeader(IOutputter.Context context, Writer artefact, Column[] columns, boolean hasDetailsLink) throws IOException {
        boolean showTableHeader = "true".equals(context.param("html.show_table_header", "true"));
        if (showTableHeader) {
            artefact.append("<thead><tr>");
            int ii = 0;
            while (ii < columns.length) {
                if (context.isColumnVisible(ii)) {
                    artefact.append("<th>").append(columns[ii].getLabel()).append("</th>");
                }
                ++ii;
            }
            if (hasDetailsLink) {
                artefact.append("<th>" + Messages.HtmlOutputter_Label_Details + "</th>");
            }
            artefact.append("</tr></thead>");
        }
    }

    private void renderTotalsRow(IOutputter.Context context, Writer artefact, RefinedStructuredResult result, List<?> elements, TotalsRow totalsRow, Column[] columns, int[] branches, boolean hasDetailsLink) throws IOException {
        if (context.isTotalsRowVisible()) {
            result.calculateTotals(elements, totalsRow, new VoidProgressListener());
            URL url = totalsRow.getIcon();
            String iconUrl = context.addIcon(url);
            artefact.append("<tr class=\"totals\">");
            int i = 0;
            while (i < columns.length) {
                if (context.isColumnVisible(i)) {
                    if (i == 0) {
                        artefact.append("<td>");
                        if (branches.length > 0) {
                            branches[branches.length - 1] = 3;
                        }
                        this.renderTreeIndentation(artefact, branches);
                        String alt = this.altText(url);
                        artefact.append("<img src=\"").append(iconUrl).append("\" alt=\"" + alt + "\">");
                        artefact.append("<ul><li>");
                        artefact.append(totalsRow.getLabel(i));
                        artefact.append("</li></ul>");
                        artefact.append("</td>");
                    } else {
                        if (columns[i].isNumeric()) {
                            artefact.append("<td align=\"right\">");
                        } else {
                            artefact.append("<td>");
                        }
                        artefact.append(totalsRow.getLabel(i)).append("</td>");
                    }
                }
                ++i;
            }
            if (hasDetailsLink) {
                artefact.append("<td/>");
            }
            artefact.append("</tr>");
        }
    }

    private void renderTree(IOutputter.Context context, RefinedTree tree, Writer artefact, boolean hasDetailsLink) throws IOException {
        Column[] columns = tree.getColumns();
        artefact.append("<table class=\"result\">");
        this.renderTableHeader(context, artefact, columns, hasDetailsLink);
        artefact.append("<tbody class=\"tree\">");
        this.renderFilterRow(context, artefact, tree, hasDetailsLink);
        this.renderChildren(context, artefact, tree, columns, tree.getElements(), 0, new int[0], hasDetailsLink);
        artefact.append("</tbody></table>");
    }

    private void renderChildren(IOutputter.Context context, Writer artefact, RefinedTree tree, Column[] columns, List<?> elements, int level, int[] branches, boolean hasDetailsLink) throws IOException {
        int numberOfRowsToDisplay = context.hasLimit() && context.getLimit() < elements.size() ? context.getLimit() : elements.size();
        TotalsRow totalsRow = tree.buildTotalsRow(elements);
        totalsRow.setVisibleItems(numberOfRowsToDisplay);
        int i = 0;
        while (i < numberOfRowsToDisplay) {
            Object element = elements.get(i);
            boolean isExpanded = tree.isExpanded(element);
            List<?> children = tree.hasChildren(element) ? tree.getChildren(element) : null;
            boolean hasChildren = children != null && !children.isEmpty();
            artefact.append("<tr");
            if (tree.isSelected(element)) {
                artefact.append(" class=\"selected\"");
            }
            artefact.append(">");
            if (context.isColumnVisible(0)) {
                artefact.append("<td>");
                if (!(i != numberOfRowsToDisplay - 1 || totalsRow.isVisible() && context.isTotalsRowVisible() || branches.length <= 0)) {
                    branches[branches.length - 1] = 3;
                }
                this.renderTreeIndentation(artefact, branches);
                URL url = tree.getIcon(element);
                String iconUrl = context.addIcon(url);
                if (iconUrl != null) {
                    String alt = this.altText(url);
                    artefact.append("<img src=\"").append(iconUrl).append("\" alt=\"" + alt + "\">");
                }
                artefact.append("<ul><li>");
                this.renderColumnValue(context, artefact, tree, columns, element, 0);
                if (!isExpanded && hasChildren) {
                    artefact.append(" &raquo;");
                }
                artefact.append("</li></ul>");
                artefact.append("</td>");
            }
            this.renderDataColumns(context, artefact, tree, columns, element, hasDetailsLink);
            artefact.append("</tr>");
            if (isExpanded && hasChildren && level < 100) {
                int[] newBranches = new int[branches.length + 1];
                System.arraycopy(branches, 0, newBranches, 0, branches.length);
                newBranches[newBranches.length - 1] = 2;
                if (newBranches.length > 1) {
                    int last = newBranches[newBranches.length - 2];
                    newBranches[newBranches.length - 2] = last == 2 ? 1 : 0;
                }
                this.renderChildren(context, artefact, tree, columns, children, level + 1, newBranches, hasDetailsLink);
            } else if (level == 100) {
                this.renderDepthRow(artefact);
            }
            ++i;
        }
        if (totalsRow.isVisible()) {
            this.renderTotalsRow(context, artefact, tree, elements, totalsRow, columns, branches, hasDetailsLink);
        }
    }

    private void renderTreeIndentation(Writer artefact, int[] branches) throws IOException {
        int[] nArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            int branch = nArray[n2];
            switch (branch) {
                case 0: {
                    artefact.append(".");
                    break;
                }
                case 1: {
                    artefact.append("|");
                    break;
                }
                case 2: {
                    artefact.append("+");
                    break;
                }
                case 3: {
                    artefact.append("\\");
                }
            }
            ++n2;
        }
    }

    private void renderDepthRow(Writer artefact) throws IOException {
        artefact.append("<tr class=\"totals\">");
        artefact.append("<td style=\"padding-left:1000px\">").append("&raquo; " + Messages.HtmlOutputter_Msg_TreeIsLimited).append("</td>");
        artefact.append("</tr>");
    }

    private void renderDataColumns(IOutputter.Context context, Writer artefact, RefinedStructuredResult structured, Column[] columns, Object row, boolean hasDetailsLink) throws IOException {
        int columnIndex = 1;
        while (columnIndex < columns.length) {
            if (context.isColumnVisible(columnIndex)) {
                if (columns[columnIndex].isNumeric()) {
                    artefact.append("<td align=\"right\">");
                } else {
                    artefact.append("<td>");
                }
                this.renderColumnValue(context, artefact, structured, columns, row, columnIndex);
                artefact.append("</td>");
            }
            ++columnIndex;
        }
        if (hasDetailsLink) {
            artefact.append("<td>");
            for (DetailResultProvider p : structured.getResultMetaData().getDetailResultProviders()) {
                if (!p.hasResult(row)) continue;
                try {
                    String link = context.addContextResult(p.getLabel(), p.getResult(row, new VoidProgressListener()));
                    if (link == null) continue;
                    artefact.append("<a href=\"").append(link).append("\">");
                    URL url = p.getIcon();
                    String iconUrl = context.addIcon(url);
                    if (iconUrl != null) {
                        String alt = this.altText(url);
                        artefact.append("<img src=\"").append(iconUrl).append("\" alt=\"" + alt + "\">");
                    }
                    artefact.append(p.getLabel());
                    artefact.append("</a>");
                }
                catch (SnapshotException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            artefact.append("</td>");
        }
    }

    private void renderColumnValue(IOutputter.Context context, Writer artefact, RefinedStructuredResult structured, Column[] columns, Object row, int columnIndex) throws IOException {
        String suffix;
        String label;
        String prefix;
        IDecorator decorator = columns[columnIndex].getDecorator();
        if (decorator != null && (prefix = decorator.prefix(row)) != null) {
            artefact.append("<strong>").append(HTMLUtils.escapeText(prefix)).append("</strong> ");
        }
        if ((label = structured.getFormattedColumnValue(row, columnIndex)).length() > 0) {
            label = HTMLUtils.escapeText(label);
            if (columnIndex == 0) {
                this.renderLink(context, artefact, structured, row, label);
            } else {
                artefact.append(label);
            }
        }
        if (decorator != null && (suffix = decorator.suffix(row)) != null) {
            artefact.append(" <strong>").append(HTMLUtils.escapeText(suffix)).append("</strong>");
        }
    }

    private boolean moreContextObjects(IContextObject c1, IContextObject c2) {
        if (c2 == null) {
            return false;
        }
        if (c1 == null) {
            return true;
        }
        if (c1.equals(c2)) {
            return false;
        }
        if (c1.getObjectId() != c2.getObjectId() && c2.getObjectId() != -1) {
            return true;
        }
        return c1 instanceof IContextObjectSet || c2 instanceof IContextObjectSet;
    }

    private void renderLink(IOutputter.Context context, Writer artefact, IStructuredResult thing, Object row, String label) throws IOException {
        IContextObject ctx = thing.getContext(row);
        this.renderContext(context, label, null, ctx, artefact);
        boolean first = true;
        boolean done = false;
        for (ContextProvider prov : thing.getResultMetaData().getContextProviders()) {
            IContextObject ctx1 = prov.getContext(row);
            if (!this.moreContextObjects(ctx, ctx1)) continue;
            if (first) {
                first = false;
                done = true;
            }
            artefact.append("<br>");
            String contextLabel = HTMLUtils.escapeText(prov.getLabel());
            this.renderContext(context, contextLabel, prov.getIcon(), ctx1, artefact);
        }
    }

    private void renderContext(IOutputter.Context context, String label, URL url, IContextObject ctx, Writer artefact) throws IOException {
        String alt;
        String iconURL = context.addIcon(url);
        int objectId = -1;
        if (ctx != null) {
            objectId = ctx.getObjectId();
        }
        if (objectId >= 0) {
            try {
                String externalIdentifier = context.getQueryContext().mapToExternalIdentifier(objectId);
                artefact.append("<a href=\"").append(QueryObjectLink.forObject(externalIdentifier)).append("\">");
                if (iconURL != null) {
                    String alt2 = this.altText(url);
                    artefact.append("<img src=\"").append(iconURL).append("\" alt=\"" + alt2 + "\">");
                }
                artefact.append(label).append("</a>");
            }
            catch (SnapshotException snapshotException) {
                if (iconURL != null) {
                    alt = this.altText(url);
                    artefact.append("<img src=\"").append(iconURL).append("\" alt=\"" + alt + "\">");
                }
                artefact.append(label);
            }
        } else {
            if (iconURL != null) {
                alt = this.altText(url);
                artefact.append("<img src=\"").append(iconURL).append("\" alt=\"" + alt + "\">");
            }
            artefact.append(label);
        }
        if (ctx instanceof IContextObjectSet) {
            IContextObjectSet set = (IContextObjectSet)ctx;
            String oqlCommand = set.getOQL();
            int[] objs = set.getObjectIds();
            if (objs.length > 0) {
                int n = Math.min(this.maxLinkObjects, objs.length);
                if (objs.length > n && oqlCommand != null) {
                    artefact.append("<br><a href=\"");
                    StringBuilder sb = new StringBuilder("oql");
                    sb.append(" ");
                    sb.append('\"').append(oqlCommand).append('\"');
                    artefact.append(QueryObjectLink.forQuery(sb.toString())).append("\">");
                    artefact.append(Messages.HtmlOutputter_Label_AllObjects);
                    artefact.append("</a>");
                } else {
                    artefact.append("<br><a href=\"");
                    StringBuilder sb = new StringBuilder("list_objects");
                    int i = 0;
                    while (i < n) {
                        try {
                            String externalIdentifier = context.getQueryContext().mapToExternalIdentifier(objs[i]);
                            sb.append(" ");
                            sb.append(externalIdentifier);
                        }
                        catch (SnapshotException snapshotException) {}
                        ++i;
                    }
                    artefact.append(QueryObjectLink.forQuery(sb.toString())).append("\">");
                    if (n < objs.length) {
                        artefact.append(MessageUtil.format(Messages.HtmlOutputter_Label_FirstObjects, n, objs.length));
                    } else {
                        artefact.append(MessageUtil.format(Messages.HtmlOutputter_Label_AllNObjects, objs.length));
                    }
                    artefact.append("</a>");
                }
            }
        }
    }

    private void renderText(IOutputter.Context context, TextResult textResult, Writer writer, boolean hasDetailsLink) throws IOException {
        if (textResult.isHtml()) {
            writer.append("<div>");
            String html = textResult.getText();
            if (!html.startsWith("<p") && !html.startsWith("<h")) {
                writer.append("<p>");
            }
            if (!hasDetailsLink) {
                writer.append(html);
            } else {
                this.resolveDetailLinks(context, textResult, writer);
            }
            writer.append("</div>");
        } else {
            writer.append("<p>");
            writer.append("<pre>");
            writer.append(HTMLUtils.escapeText(textResult.getText()));
            writer.append("</pre>");
            writer.append("</p>");
        }
    }

    private void resolveDetailLinks(IOutputter.Context context, TextResult textResult, Writer writer) throws IOException {
        List<DetailResultProvider> detailProvider = textResult.getResultMetaData().getDetailResultProviders();
        String text = textResult.getText();
        int start = 0;
        int length = text.length();
        int protocolIndex = text.indexOf("mat://");
        while (protocolIndex >= 0) {
            int endIndex = text.indexOf(34, protocolIndex);
            if (endIndex < 0) break;
            String url = text.substring(protocolIndex, endIndex);
            QueryObjectLink link = QueryObjectLink.parse(url);
            if (link == null || link.getType() != QueryObjectLink.Type.DETAIL_RESULT) {
                writer.append(text.substring(start, endIndex));
            } else {
                int targetIndex = link.getTarget().indexOf(47);
                String name = link.getTarget().substring(0, targetIndex);
                String identifier = link.getTarget().substring(targetIndex + 1);
                writer.append(text.subSequence(start, protocolIndex));
                boolean done = false;
                for (DetailResultProvider provider : detailProvider) {
                    if (!name.equals(provider.getLabel())) continue;
                    if (!provider.hasResult(identifier)) break;
                    try {
                        String l = context.addContextResult(provider.getLabel(), provider.getResult(identifier, new VoidProgressListener()));
                        if (l == null) break;
                        writer.append(l);
                        done = true;
                        break;
                    }
                    catch (SnapshotException e) {
                        IOException ioe = new IOException(e.getMessage());
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
                if (!done) {
                    writer.append(url);
                }
            }
            start = endIndex;
            protocolIndex = text.indexOf("mat://", start);
        }
        if (start < length) {
            writer.append(text.substring(start));
        }
    }
}

