/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPCodeActionsMenu
extends ContributionItem
implements IWorkbenchContribution {
    private LanguageServiceAccessor.LSPDocumentInfo info;
    private Range range;

    public void initialize(IServiceLocator serviceLocator) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            this.info = LanguageServiceAccessor.getLSPDocumentInfoFor(LSPEclipseUtils.getDocument(textEditor), capabilities -> Boolean.TRUE.equals(capabilities.getCodeActionProvider()));
            if (this.info != null) {
                ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
                try {
                    this.range = new Range(LSPEclipseUtils.toPosition(selection.getOffset(), this.info.getDocument()), LSPEclipseUtils.toPosition(selection.getOffset() + selection.getLength(), this.info.getDocument()));
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }

    public void fill(final Menu menu, final int index) {
        final MenuItem item = new MenuItem(menu, 0, index);
        item.setEnabled(false);
        if (this.info == null) {
            item.setText(Messages.notImplemented);
            return;
        }
        item.setText(Messages.computing);
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(this.info.getFileUri().toString()));
        params.setRange(this.range);
        params.setContext(context);
        CompletableFuture codeActions = this.info.getLanguageClient().getTextDocumentService().codeAction(params);
        codeActions.whenComplete(new BiConsumer<List<? extends Command>, Throwable>(){

            @Override
            public void accept(final List<? extends Command> t, final Throwable u) {
                UIJob job = new UIJob(menu.getDisplay(), Messages.updateCodeActions_menu){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (u != null) {
                            item.setText(u.getMessage());
                        } else {
                            for (Command command : t) {
                                if (command == null) continue;
                                MenuItem item2 = new MenuItem(menu, 0, index);
                                item2.setText(command.getTitle());
                                item2.setEnabled(false);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        super.fill(menu, index);
    }
}

