/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;

public class ImageRunSelectionModel
extends BaseDatabindingModel {
    public static final String CONNECTION_NAMES = "connectionNames";
    public static final String SELECTED_CONNECTION_NAME = "selectedConnectionName";
    public static final String SELECTED_IMAGE_NAME = "selectedImageName";
    public static final String SELECTED_IMAGE = "selectedImage";
    public static final String SELECTED_IMAGE_NEEDS_PULLING = "selectedImageNeedsPulling";
    public static final String IMAGE_NAMES = "imageNames";
    public static final String CONTAINER_NAME = "containerName";
    public static final String COMMAND = "command";
    public static final String ENTRYPOINT = "entrypoint";
    public static final String PUBLISH_ALL_PORTS = "publishAllPorts";
    public static final String EXPOSED_PORTS = "exposedPorts";
    public static final String SELECTED_PORTS = "selectedPorts";
    public static final String LINKS = "links";
    public static final String INTERACTIVE_MODE = "interactiveMode";
    public static final String ALLOCATE_PSEUDO_TTY = "allocatePseudoTTY";
    public static final String REMOVE_WHEN_EXITS = "removeWhenExits";
    public static final String PRIVILEGED = "privileged";
    public static final String UNCONFINED = "unconfined";
    private String selectedConnectionName = "";
    private List<String> connectionNames;
    private Map<String, IDockerConnection> connections;
    private String selectedImageName;
    private boolean selectedImageNeedsPulling = false;
    private List<String> imageNames;
    private Map<String, IDockerImage> images;
    private String containerName;
    private String command;
    private String entrypoint;
    private boolean publishAllPorts = true;
    private final WritableList<ExposedPortModel> exposedPorts = new WritableList();
    private Set<ExposedPortModel> selectedPorts;
    private final WritableList<ContainerLinkModel> links = new WritableList();
    private boolean interactiveMode = false;
    private boolean allocatePseudoTTY = false;
    private boolean removeWhenExits = false;
    private boolean privileged = false;
    private boolean unconfined = false;

    public ImageRunSelectionModel(IDockerConnection selectedConnection) {
        this.refreshConnectionNames();
        if (selectedConnection != null) {
            this.setSelectedConnectionName(selectedConnection.getName());
        }
        this.refreshImageNames();
    }

    public void refreshConnectionNames() {
        this.connectionNames = new ArrayList<String>();
        this.connections = new HashMap<String, IDockerConnection>();
        IDockerConnection[] iDockerConnectionArray = DockerConnectionManager.getInstance().getConnections();
        int n = iDockerConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            String name = connection.getName();
            this.connections.put(name, connection);
            this.connectionNames.add(name);
            ++n2;
        }
    }

    public void refreshImageNames() {
        ArrayList<String> refreshedImageNames = new ArrayList<String>();
        HashMap<String, IDockerImage> refreshedImages = new HashMap<String, IDockerImage>();
        IDockerConnection connection = this.getSelectedConnection();
        if (connection != null && connection.isOpen()) {
            connection.getImages().stream().filter(image -> !image.isIntermediateImage() && !image.isDangling()).forEach(image -> image.repoTags().stream().forEach(repoTag -> {
                refreshedImages.put((String)repoTag, (IDockerImage)image);
                refreshedImageNames.add((String)repoTag);
            }));
            Collections.sort(refreshedImageNames);
        }
        this.images = refreshedImages;
        this.setImageNames(refreshedImageNames);
    }

    public ImageRunSelectionModel(IDockerImage selectedImage) {
        this(selectedImage.getConnection());
        if (selectedImage.tags().contains("latest")) {
            this.setSelectedImageName(ImageRunSelectionModel.getImageName(selectedImage.repo(), "latest"));
        } else {
            String lastTag = (String)selectedImage.tags().get(selectedImage.tags().size() - 1);
            this.setSelectedImageName(ImageRunSelectionModel.getImageName(selectedImage.repo(), lastTag));
        }
    }

    public boolean isPublishAllPorts() {
        return this.publishAllPorts;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        this.firePropertyChange(PUBLISH_ALL_PORTS, this.publishAllPorts, this.publishAllPorts);
    }

    public List<String> getConnectionNames() {
        return this.connectionNames;
    }

    public void setConnectionNames(List<String> connectionNames) {
        this.connectionNames = connectionNames;
        this.firePropertyChange(CONNECTION_NAMES, this.connectionNames, this.connectionNames);
    }

    public String getSelectedConnectionName() {
        return this.selectedConnectionName;
    }

    public void setSelectedConnectionName(String selectedConnectionName) {
        this.selectedConnectionName = selectedConnectionName;
        this.firePropertyChange(SELECTED_CONNECTION_NAME, this.selectedConnectionName, this.selectedConnectionName);
        this.refreshImageNames();
    }

    public IDockerConnection getSelectedConnection() {
        return this.connections.get(this.selectedConnectionName);
    }

    public List<String> getImageNames() {
        return this.imageNames;
    }

    public void setImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        this.firePropertyChange(IMAGE_NAMES, this.imageNames, this.imageNames);
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }

    public boolean isSelectedImageNeedsPulling() {
        return this.selectedImageNeedsPulling;
    }

    public void setSelectedImageNeedsPulling(boolean selectedImageNeedsPulling) {
        this.selectedImageNeedsPulling = selectedImageNeedsPulling;
        this.firePropertyChange(SELECTED_IMAGE_NEEDS_PULLING, this.selectedImageNeedsPulling, this.selectedImageNeedsPulling);
    }

    public void setSelectedImageName(String selectedImageName) {
        this.selectedImageName = selectedImageName;
        this.firePropertyChange(SELECTED_IMAGE_NAME, this.selectedImageName, this.selectedImageName);
    }

    public IDockerImage getSelectedImage() {
        return this.images.get(this.selectedImageName);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
        this.firePropertyChange(CONTAINER_NAME, this.containerName, this.containerName);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        if ((this.getEntrypoint() == null || this.getEntrypoint().isEmpty()) && !command.contains("'") && command.matches("^/bin/sh\\s+-c.*")) {
            command = String.valueOf(command) + "'";
            command = command.replaceFirst("-c ", "-c '");
        }
        this.command = command;
        this.firePropertyChange(COMMAND, this.command, this.command);
    }

    public void setCommand(List<String> cmdElements) {
        StringBuilder commandBuilder = new StringBuilder();
        if (cmdElements != null) {
            for (String cmdElement : cmdElements) {
                commandBuilder.append(cmdElement).append(' ');
            }
        }
        this.setCommand(commandBuilder.toString());
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public void setEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
        this.firePropertyChange(ENTRYPOINT, this.entrypoint, this.entrypoint);
    }

    public void setEntrypoint(List<String> entrypointElements) {
        StringBuilder entrypointBuilder = new StringBuilder();
        if (entrypointElements != null) {
            for (String entrypoint : entrypointElements) {
                entrypointBuilder.append(entrypoint).append(' ');
            }
        }
        this.setEntrypoint(entrypointBuilder.toString());
    }

    public WritableList<ExposedPortModel> getExposedPorts() {
        return this.exposedPorts;
    }

    public void addAvailablePort(ExposedPortModel port) {
        this.exposedPorts.add((Object)port);
    }

    public void removeAvailablePort(ExposedPortModel port) {
        this.exposedPorts.remove((Object)port);
    }

    public void setExposedPorts(List<ExposedPortModel> exposedPorts) {
        this.exposedPorts.clear();
        this.exposedPorts.addAll(exposedPorts);
    }

    public void addExposedPort(ExposedPortModel exposedPort) {
        if (!this.exposedPorts.contains((Object)exposedPort)) {
            this.exposedPorts.add((Object)exposedPort);
        }
    }

    public void removeExposedPort(ExposedPortModel exposedPort) {
        this.exposedPorts.remove((Object)exposedPort);
    }

    public void removeExposedPorts() {
        this.exposedPorts.clear();
    }

    public Set<ExposedPortModel> getSelectedPorts() {
        return this.selectedPorts;
    }

    public void setSelectedPorts(Set<ExposedPortModel> ports) {
        this.selectedPorts = ports;
        this.firePropertyChange(SELECTED_PORTS, this.selectedPorts, this.selectedPorts);
    }

    public WritableList<ContainerLinkModel> getLinks() {
        return this.links;
    }

    public void addLink(String containerName, String containerAlias) {
        this.addLink(new ContainerLinkModel(containerName, containerAlias));
    }

    public void addLink(ContainerLinkModel containerLink) {
        this.links.add((Object)containerLink);
    }

    public void addLink(int index, String containerName, String containerAlias) {
        this.links.add(index, (Object)new ContainerLinkModel(containerName, containerAlias));
    }

    public void removeLink(ContainerLinkModel link) {
        this.links.remove((Object)link);
    }

    public void removeLinks() {
        this.links.clear();
    }

    public void setLinks(WritableList<ContainerLinkModel> links) {
        this.links.clear();
        this.links.addAll(links);
    }

    public void setLinks(List<String> links) {
        for (String link : links) {
            String[] items = link.split(":");
            if (items.length != 2) continue;
            this.addLink(items[0], items[1]);
        }
    }

    public static String getImageName(String repo, String tag) {
        return String.valueOf(repo) + ":" + tag;
    }

    public boolean isAllocatePseudoTTY() {
        return this.allocatePseudoTTY;
    }

    public void setAllocatePseudoTTY(boolean allocatePseudoTTY) {
        this.allocatePseudoTTY = allocatePseudoTTY;
        this.firePropertyChange(ALLOCATE_PSEUDO_TTY, this.allocatePseudoTTY, this.allocatePseudoTTY);
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
        this.firePropertyChange(INTERACTIVE_MODE, this.interactiveMode, this.interactiveMode);
    }

    public boolean isRemoveWhenExits() {
        return this.removeWhenExits;
    }

    public void setRemoveWhenExits(boolean removeWhenExits) {
        this.removeWhenExits = removeWhenExits;
        this.firePropertyChange(REMOVE_WHEN_EXITS, this.removeWhenExits, this.removeWhenExits);
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
        this.firePropertyChange(PRIVILEGED, this.privileged, this.privileged);
    }

    public boolean isUnconfined() {
        return this.unconfined;
    }

    public void setUnconfined(boolean unconfined) {
        this.unconfined = unconfined;
        this.firePropertyChange(UNCONFINED, this.unconfined, this.unconfined);
    }

    public static class ContainerLinkModel
    extends BaseDatabindingModel {
        private static final String CONTAINER_SEPARATOR = ":";
        public static final String CONTAINER_NAME = "containerName";
        public static final String CONTAINER_ALIAS = "containerAlias";
        private String containerName;
        private String containerAlias;

        public ContainerLinkModel() {
        }

        public ContainerLinkModel(String containerName, String alias) {
            this.containerName = containerName;
            this.containerAlias = alias;
        }

        public static ContainerLinkModel createContainerLinkModel(String fromString) {
            String[] s = fromString.split(CONTAINER_SEPARATOR);
            return new ContainerLinkModel(s[0], s[1]);
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
            this.firePropertyChange("containerName", this.containerName, this.containerName);
        }

        public String getContainerAlias() {
            return this.containerAlias;
        }

        public void setContainerAlias(String alias) {
            this.containerAlias = alias;
            this.firePropertyChange(CONTAINER_ALIAS, this.containerAlias, this.containerAlias);
        }

        public String toString() {
            return String.valueOf(this.containerName) + CONTAINER_SEPARATOR + this.containerAlias;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
            result = 31 * result + (this.containerName == null ? 0 : this.containerName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainerLinkModel other = (ContainerLinkModel)obj;
            if (this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias)) {
                return false;
            }
            return !(this.containerName == null ? other.containerName != null : !this.containerName.equals(other.containerName));
        }
    }

    public static class ExposedPortModel
    extends BaseDatabindingModel
    implements Comparable<ExposedPortModel> {
        private static final String SEPARATOR = ":";
        private static final String CONTAINER_TYPE_SEPARATOR = "/";
        public static final String SELECTED = "selected";
        public static final String CONTAINER_PORT = "containerPort";
        public static final String PORT_TYPE = "portType";
        public static final String HOST_ADDRESS = "hostAddress";
        public static final String HOST_PORT = "hostPort";
        private final String id = UUID.randomUUID().toString();
        private boolean selected;
        private String containerPort;
        private String portType;
        private String hostAddress;
        private String hostPort;

        public static List<ExposedPortModel> fromStrings(Collection<String> exposedPortInfos) {
            ArrayList<ExposedPortModel> exposedPorts = new ArrayList<ExposedPortModel>();
            for (String exposedPortInfo : exposedPortInfos) {
                ExposedPortModel exposedPort = ExposedPortModel.fromString(exposedPortInfo);
                if (exposedPort == null) continue;
                exposedPorts.add(exposedPort);
            }
            return exposedPorts;
        }

        public static ExposedPortModel fromString(String exposedPortInfo) {
            String privatePort = exposedPortInfo.substring(0, exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR));
            int firstColumnSeparator = exposedPortInfo.indexOf(SEPARATOR);
            if (firstColumnSeparator == -1 && exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR) != -1) {
                String type = exposedPortInfo.substring(exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR));
                ExposedPortModel exposedPort = new ExposedPortModel(privatePort, type, "", privatePort);
                return exposedPort;
            }
            int secondColumnSeparator = exposedPortInfo.indexOf(SEPARATOR, firstColumnSeparator + 1);
            String type = exposedPortInfo.substring(exposedPortInfo.indexOf(CONTAINER_TYPE_SEPARATOR), firstColumnSeparator);
            String hostIP = exposedPortInfo.substring(firstColumnSeparator + 1, secondColumnSeparator);
            String hostPort = exposedPortInfo.substring(secondColumnSeparator + 1);
            ExposedPortModel exposedPort = new ExposedPortModel(privatePort, type, hostIP, hostPort);
            return exposedPort;
        }

        public ExposedPortModel(String privatePort, String type, String hostAddress, String hostPort) {
            Assert.isNotNull((Object)privatePort, (String)"Port Mapping privatePort cannot be null");
            Assert.isNotNull((Object)type, (String)"Port Mapping portType cannot be null");
            this.containerPort = privatePort;
            this.hostPort = hostPort;
            this.portType = type;
            this.hostAddress = hostAddress;
        }

        public static ExposedPortModel createPortModel(String stringValue) {
            String[] elements = stringValue.split(SEPARATOR);
            String[] containerPortElements = elements[0].split(CONTAINER_TYPE_SEPARATOR);
            ExposedPortModel model = new ExposedPortModel(containerPortElements[0], containerPortElements[1], elements[1], elements[2]);
            model.selected = elements.length == 4 ? Boolean.valueOf(elements[3]) : true;
            return model;
        }

        public String getContainerPort() {
            return this.containerPort;
        }

        public void setContainerPort(String containerPort) {
            this.containerPort = containerPort;
            this.firePropertyChange(CONTAINER_PORT, this.containerPort, this.containerPort);
        }

        public String getPortType() {
            return this.portType;
        }

        public void setPortType(String type) {
            this.portType = type;
            this.firePropertyChange(PORT_TYPE, this.portType, this.portType);
        }

        public boolean getSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.firePropertyChange(SELECTED, this.selected, this.selected);
        }

        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
            this.firePropertyChange(HOST_PORT, this.hostPort, this.hostPort);
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            this.firePropertyChange(HOST_ADDRESS, this.hostAddress, this.hostAddress);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExposedPortModel other = (ExposedPortModel)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        @Override
        public int compareTo(ExposedPortModel other) {
            return this.containerPort.compareTo(other.containerPort);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(this.containerPort) + CONTAINER_TYPE_SEPARATOR + this.portType + SEPARATOR + this.hostAddress + SEPARATOR + this.hostPort + SEPARATOR + this.selected);
            return buffer.toString();
        }
    }
}

