/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class NullAnnotationsRewriteOperations {
    static final String TYPE_USE_NAME = String.valueOf(ElementType.class.getName()) + '.' + ElementType.TYPE_USE.name();

    public static class Builder {
        IProblemLocation fProblem;
        ChangeKind fChangeKind;
        CompilationUnit fUnit;
        String fAnnotationToAdd;
        String fAnnotationToRemove;
        boolean fAllowRemove;
        boolean fAffectsParameter;
        boolean fUseNullTypeAnnotations;

        public Builder(IProblemLocation problem, CompilationUnit unit, String annotationToAdd, String annotationToRemove, boolean allowRemove, boolean affectsParameter, ChangeKind changeKind) {
            this.fChangeKind = changeKind;
            this.fUnit = unit;
            this.fAnnotationToAdd = annotationToAdd;
            this.fAnnotationToRemove = annotationToRemove;
            this.fAllowRemove = allowRemove;
            this.fAffectsParameter = affectsParameter;
            this.fProblem = problem;
            this.fUseNullTypeAnnotations = this.usesNullTypeAnnotations(unit.getJavaElement(), annotationToAdd);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private boolean usesNullTypeAnnotations(IJavaElement cu, String annotationName) {
            IJavaProject project = (IJavaProject)cu.getAncestor(2);
            if (!JavaModelUtil.is18OrHigher((IJavaProject)project)) {
                return false;
            }
            try {
                IType annotationType = project.findType(annotationName);
                if (annotationType == null) {
                    return false;
                }
                IAnnotation[] annotations = annotationType.getAnnotations();
                int i = 0;
                while (i < annotations.length) {
                    if (annotations[i].getElementName().equals(Target.class.getName())) {
                        IMemberValuePair[] iMemberValuePairArray = annotations[i].getMemberValuePairs();
                        int n = iMemberValuePairArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemberValuePair valuePair = iMemberValuePairArray[n2];
                            if (TYPE_USE_NAME.equals(valuePair.getValue())) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return false;
        }

        public boolean requiresExplicitAnnotation() {
            switch (this.fProblem.getProblemId()) {
                case 67109803: 
                case 67109804: {
                    return this.fChangeKind != ChangeKind.OVERRIDDEN;
                }
            }
            return false;
        }

        public void swapAnnotations() {
            String tmp = this.fAnnotationToAdd;
            this.fAnnotationToAdd = this.fAnnotationToRemove;
            this.fAnnotationToRemove = tmp;
        }

        public boolean is50OrHigher() {
            CompilationUnit compilationUnit = this.fUnit;
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            return JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject());
        }

        public ASTNode getCoveringNode() {
            return this.fProblem.getCoveringNode(this.fUnit);
        }

        public SignatureAnnotationRewriteOperation createAddAnnotationOperation(Set<String> handledPositions, boolean thisUnitOnly, ChangeKind changeKind) {
            SignatureAnnotationRewriteOperation result = changeKind == ChangeKind.OVERRIDDEN ? this.createAddAnnotationToOverriddenOperation() : this.createAddAnnotationOperation(changeKind == ChangeKind.TARGET, thisUnitOnly);
            if (handledPositions != null && result != null) {
                if (handledPositions.contains(result.getKey())) {
                    return null;
                }
                handledPositions.add(result.getKey());
            }
            return result;
        }

        private SignatureAnnotationRewriteOperation createAddAnnotationOperation(boolean changeTargetMethod, boolean thisUnitOnly) {
            if (!this.is50OrHigher()) {
                return null;
            }
            ASTNode selectedNode = this.getCoveringNode();
            if (selectedNode == null) {
                return null;
            }
            ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
            ASTNode declaringNode = Builder.getDeclaringNode(selectedNode);
            switch (this.fProblem.getProblemId()) {
                case 67109780: {
                    break;
                }
                case 67109778: {
                    if (declaringNode != null) break;
                    declaringNode = selectedNode;
                    break;
                }
                default: {
                    if (this.fAllowRemove || !NullAnnotationsFix.hasExplicitNullAnnotation(cu, this.fProblem.getOffset())) break;
                    return null;
                }
            }
            String annotationNameLabel = this.fAnnotationToAdd;
            int lastDot = annotationNameLabel.lastIndexOf(46);
            if (lastDot != -1) {
                annotationNameLabel = annotationNameLabel.substring(lastDot + 1);
            }
            annotationNameLabel = BasicElementLabels.getJavaElementName((String)annotationNameLabel);
            if (changeTargetMethod) {
                MethodInvocation methodInvocation = null;
                if (this.fAffectsParameter) {
                    if (selectedNode.getParent() instanceof MethodInvocation) {
                        methodInvocation = (MethodInvocation)selectedNode.getParent();
                    }
                } else if (selectedNode instanceof MethodInvocation) {
                    methodInvocation = (MethodInvocation)selectedNode;
                }
                if (methodInvocation != null) {
                    int paramIdx = methodInvocation.arguments().indexOf(selectedNode);
                    IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                    MethodDeclaration methodDecl = this.findMethodDeclarationInUnit(cu, methodBinding, thisUnitOnly);
                    if (methodDecl == null) {
                        return null;
                    }
                    if (this.fAffectsParameter) {
                        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_target_method_parameter_nullness, new Object[]{methodInvocation.getName(), annotationNameLabel});
                        return new ParameterAnnotationRewriteOperation(methodDecl, paramIdx, message, this);
                    }
                    MethodDeclaration declaration = methodDecl;
                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_return_nullness, new String[]{declaration.getName().getIdentifier(), annotationNameLabel});
                    return new ReturnAnnotationRewriteOperation(declaration, message, this);
                }
            } else if (declaringNode instanceof MethodDeclaration || declaringNode instanceof LambdaExpression) {
                switch (this.fProblem.getProblemId()) {
                    case 67109779: 
                    case 67109780: 
                    case 67109781: 
                    case 67109782: {
                        ParameterAnnotationRewriteOperation.IndexedParameter parameter = this.findParameterDeclaration(selectedNode);
                        if (parameter == null) break;
                        switch (declaringNode.getNodeType()) {
                            case 31: {
                                MethodDeclaration method = (MethodDeclaration)declaringNode;
                                String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                return new ParameterAnnotationRewriteOperation(method, parameter.index, message, this);
                            }
                            case 86: {
                                LambdaExpression lambda = (LambdaExpression)declaringNode;
                                String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                return ParameterAnnotationRewriteOperation.create(lambda, parameter, message, this);
                            }
                        }
                        return null;
                    }
                    case 16778126: 
                    case 16778127: 
                    case 16778128: 
                    case 67109803: 
                    case 67109804: 
                    case 536871843: 
                    case 536871844: 
                    case 536871845: 
                    case 536871873: {
                        if (this.fAffectsParameter) {
                            ParameterAnnotationRewriteOperation.IndexedParameter parameter;
                            if (!(selectedNode instanceof SimpleName) || (parameter = this.findReferencedParameter(selectedNode)) == null) break;
                            switch (declaringNode.getNodeType()) {
                                case 31: {
                                    MethodDeclaration declaration = (MethodDeclaration)declaringNode;
                                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                    return new ParameterAnnotationRewriteOperation(declaration, parameter.index, message, this);
                                }
                                case 86: {
                                    LambdaExpression lambda = (LambdaExpression)declaringNode;
                                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                    return ParameterAnnotationRewriteOperation.create(lambda, parameter, message, this);
                                }
                            }
                            return null;
                        }
                    }
                    case 67109778: {
                        if (declaringNode.getNodeType() != 31) break;
                        MethodDeclaration declaration = (MethodDeclaration)declaringNode;
                        String name = declaration.getName().getIdentifier();
                        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_return_nullness, new String[]{name, annotationNameLabel});
                        return new ReturnAnnotationRewriteOperation(declaration, message, this);
                    }
                    default: {
                        return null;
                    }
                }
            }
            return null;
        }

        private SignatureAnnotationRewriteOperation createAddAnnotationToOverriddenOperation() {
            if (!this.is50OrHigher()) {
                return null;
            }
            ASTNode selectedNode = this.getCoveringNode();
            if (selectedNode == null) {
                return null;
            }
            ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
            ASTNode declaringNode = Builder.getDeclaringNode(selectedNode);
            switch (this.fProblem.getProblemId()) {
                case 67109779: 
                case 67109780: {
                    break;
                }
                case 67109778: 
                case 67109803: {
                    if (declaringNode != null) break;
                    declaringNode = selectedNode;
                    break;
                }
                default: {
                    return null;
                }
            }
            String annotationNameLabel = this.fAnnotationToAdd;
            int lastDot = annotationNameLabel.lastIndexOf(46);
            if (lastDot != -1) {
                annotationNameLabel = annotationNameLabel.substring(lastDot + 1);
            }
            annotationNameLabel = BasicElementLabels.getJavaElementName((String)annotationNameLabel);
            if (declaringNode instanceof MethodDeclaration) {
                MethodDeclaration declaration = (MethodDeclaration)declaringNode;
                switch (this.fProblem.getProblemId()) {
                    case 67109778: {
                        if (!this.hasNullAnnotation(declaration)) {
                            return null;
                        }
                    }
                    case 67109779: 
                    case 67109780: 
                    case 67109803: {
                        if (this.fAffectsParameter) {
                            return this.createChangeOverriddenParameterOperation(cu, declaration, selectedNode, annotationNameLabel);
                        }
                        return this.createChangeOverriddenReturnOperation(cu, declaration, annotationNameLabel);
                    }
                }
                return null;
            }
            return null;
        }

        private SignatureAnnotationRewriteOperation createChangeOverriddenParameterOperation(ICompilationUnit cu, MethodDeclaration declaration, ASTNode selectedNode, String annotationNameLabel) {
            IMethodBinding methodDeclBinding = declaration.resolveBinding();
            if (methodDeclBinding == null) {
                return null;
            }
            IMethodBinding overridden = Bindings.findOverriddenMethod((IMethodBinding)methodDeclBinding, (boolean)false);
            if (overridden == null) {
                return null;
            }
            MethodDeclaration overriddenDeclaration = this.findMethodDeclarationInUnit(cu, overridden, false);
            if (overriddenDeclaration == null) {
                return null;
            }
            String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_parameter_nullness, new String[]{overridden.getName(), annotationNameLabel});
            ParameterAnnotationRewriteOperation.IndexedParameter parameter = this.findParameterDeclaration(selectedNode);
            if (parameter == null) {
                return null;
            }
            return new ParameterAnnotationRewriteOperation(overriddenDeclaration, parameter.index, message, this);
        }

        private ParameterAnnotationRewriteOperation.IndexedParameter findParameterDeclaration(ASTNode selectedNode) {
            VariableDeclaration argDecl;
            VariableDeclaration variableDeclaration = argDecl = selectedNode instanceof VariableDeclaration ? (VariableDeclaration)selectedNode : (VariableDeclaration)ASTNodes.getParent((ASTNode)selectedNode, VariableDeclaration.class);
            if (argDecl != null) {
                StructuralPropertyDescriptor locationInParent = argDecl.getLocationInParent();
                if (!locationInParent.isChildListProperty()) {
                    return null;
                }
                List containingList = (List)argDecl.getParent().getStructuralProperty(locationInParent);
                return new ParameterAnnotationRewriteOperation.IndexedParameter(containingList.indexOf(argDecl), argDecl.getName().getIdentifier());
            }
            return null;
        }

        private ParameterAnnotationRewriteOperation.IndexedParameter findReferencedParameter(ASTNode selectedNode) {
            IBinding binding;
            if (selectedNode.getNodeType() == 42 && (binding = ((SimpleName)selectedNode).resolveBinding()).getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
                ASTNode current = selectedNode.getParent();
                while (current != null) {
                    List parameters = null;
                    switch (current.getNodeType()) {
                        case 31: {
                            parameters = ((MethodDeclaration)current).parameters();
                            break;
                        }
                        case 86: {
                            parameters = ((LambdaExpression)current).parameters();
                        }
                    }
                    if (parameters != null) {
                        int i = 0;
                        while (i < parameters.size()) {
                            VariableDeclaration parameter = (VariableDeclaration)parameters.get(i);
                            if (parameter.resolveBinding() == binding) {
                                return new ParameterAnnotationRewriteOperation.IndexedParameter(i, binding.getName());
                            }
                            ++i;
                        }
                    }
                    current = current.getParent();
                }
            }
            return null;
        }

        private boolean hasNullAnnotation(MethodDeclaration decl) {
            List modifiers = decl.modifiers();
            String nonnull = NullAnnotationsFix.getNonNullAnnotationName(decl.resolveBinding().getJavaElement(), false);
            String nullable = NullAnnotationsFix.getNullableAnnotationName(decl.resolveBinding().getJavaElement(), false);
            for (Object mod : modifiers) {
                if (!(mod instanceof Annotation)) continue;
                Name annotationName = ((Annotation)mod).getTypeName();
                String fullyQualifiedName = annotationName.getFullyQualifiedName();
                if (annotationName.isSimpleName() ? nonnull.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nonnull)) {
                    return true;
                }
                if (!(annotationName.isSimpleName() ? nullable.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nullable))) continue;
                return true;
            }
            return false;
        }

        private SignatureAnnotationRewriteOperation createChangeOverriddenReturnOperation(ICompilationUnit cu, MethodDeclaration declaration, String annotationNameLabel) {
            IMethodBinding methodDeclBinding = declaration.resolveBinding();
            if (methodDeclBinding == null) {
                return null;
            }
            IMethodBinding overridden = Bindings.findOverriddenMethod((IMethodBinding)methodDeclBinding, (boolean)false);
            if (overridden == null) {
                return null;
            }
            declaration = this.findMethodDeclarationInUnit(cu, overridden, false);
            if (declaration == null) {
                return null;
            }
            String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_return_nullness, new String[]{overridden.getName(), annotationNameLabel});
            return new ReturnAnnotationRewriteOperation(declaration, message, this);
        }

        private MethodDeclaration findMethodDeclarationInUnit(ICompilationUnit cu, IMethodBinding method, boolean sameUnitOnly) {
            CompilationUnit compilationUnit = this.findCUForMethod(this.fUnit, cu, method = method.getMethodDeclaration());
            if (compilationUnit == null) {
                return null;
            }
            if (sameUnitOnly && !compilationUnit.getJavaElement().equals(cu)) {
                return null;
            }
            ASTNode methodDecl = compilationUnit.findDeclaringNode(method.getKey());
            if (methodDecl == null) {
                return null;
            }
            this.fUnit = compilationUnit;
            return (MethodDeclaration)methodDecl;
        }

        private CompilationUnit findCUForMethod(CompilationUnit compilationUnit, ICompilationUnit cu, IMethodBinding methodBinding) {
            ASTNode methodDecl = compilationUnit.findDeclaringNode((IBinding)methodBinding.getMethodDeclaration());
            if (methodDecl == null) {
                ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
                if (declaringTypeDecl.isFromSource()) {
                    ICompilationUnit targetCU = null;
                    try {
                        targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)compilationUnit, (ITypeBinding)declaringTypeDecl);
                    }
                    catch (JavaModelException javaModelException) {}
                    if (targetCU != null) {
                        return ASTResolving.createQuickFixAST((ICompilationUnit)targetCU, null);
                    }
                }
                return null;
            }
            return compilationUnit;
        }

        private static ASTNode getDeclaringNode(ASTNode selectedNode) {
            while (selectedNode != null) {
                switch (selectedNode.getNodeType()) {
                    case 31: 
                    case 86: {
                        return selectedNode;
                    }
                }
                selectedNode = selectedNode.getParent();
            }
            return null;
        }
    }

    public static enum ChangeKind {
        LOCAL,
        INVERSE,
        OVERRIDDEN,
        TARGET;

    }

    static enum DefaultLocation {
        PARAMETER,
        RETURN_TYPE;

    }

    static class ParameterAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private SingleVariableDeclaration fArgument;
        private int fParameterRank;

        static ParameterAnnotationRewriteOperation create(LambdaExpression lambda, IndexedParameter parameter, String message, Builder builder) {
            IMethodBinding lambdaMethodBinding = lambda.resolveMethodBinding();
            List parameters = lambda.parameters();
            if (parameters.size() > parameter.index) {
                Object param = parameters.get(parameter.index);
                if (!(param instanceof SingleVariableDeclaration)) {
                    return null;
                }
                return new ParameterAnnotationRewriteOperation(lambdaMethodBinding, parameters, parameter.index, message, builder);
            }
            throw new RuntimeException("Argument " + parameter.name + " not found in method " + lambda.toString());
        }

        ParameterAnnotationRewriteOperation(MethodDeclaration method, int paramIdx, String message, Builder builder) {
            this(method.resolveBinding(), method.parameters(), paramIdx, message, builder);
        }

        private ParameterAnnotationRewriteOperation(IMethodBinding methodBinding, List<?> parameters, int paramIdx, String message, Builder builder) {
            super(builder);
            this.fKey = methodBinding.getKey();
            this.fArgument = (SingleVariableDeclaration)parameters.get(paramIdx);
            this.fParameterRank = paramIdx;
            this.fKey = String.valueOf(this.fKey) + this.fArgument.getName().getIdentifier();
            this.fMessage = message;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedModel) throws CoreException {
            TextEditGroup group;
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = this.getAnnotationListRewrite(this.fArgument.getType(), cuRewrite, (ASTNode)this.fArgument, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            if (!this.checkExisting(listRewrite, group = this.createTextEditGroup(this.fMessage, cuRewrite))) {
                return;
            }
            if (!this.fRequireExplicitAnnotation && (this.fUseNullTypeAnnotations ? this.hasNonNullDefault308((IBinding)this.fArgument.resolveBinding(), this.fParameterRank, DefaultLocation.PARAMETER, false) : this.hasNonNullDefault((IBinding)this.fArgument.resolveBinding()))) {
                return;
            }
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
            newAnnotation.setTypeName(ast.newName(resolvableName));
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }

        static class IndexedParameter {
            int index;
            String name;

            IndexedParameter(int index, String name) {
                this.index = index;
                this.name = name;
            }
        }
    }

    static class RemoveRedundantAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private IProblemLocation fProblem;
        private CompilationUnit fCompilationUnit;

        public RemoveRedundantAnnotationRewriteOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
            this.fCompilationUnit = compilationUnit;
            this.fProblem = problem;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedModel) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.NullAnnotationsRewriteOperations_remove_redundant_nullness_annotation, cuRewrite);
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            CompilationUnit astRoot = this.fCompilationUnit;
            ASTNode selectedNode = this.fProblem.getCoveringNode(astRoot);
            if (this.fProblem.getProblemId() == 67109786) {
                List modifiers;
                if (selectedNode instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)selectedNode;
                    modifiers = singleVariableDeclaration.modifiers();
                } else if (selectedNode instanceof FieldDeclaration) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)selectedNode;
                    modifiers = fieldDeclaration.modifiers();
                } else if (selectedNode instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)selectedNode;
                    modifiers = methodDeclaration.modifiers();
                } else {
                    return;
                }
                for (IExtendedModifier modifier : modifiers) {
                    MarkerAnnotation annotation;
                    IAnnotationBinding annotationBinding;
                    String name;
                    if (!(modifier instanceof MarkerAnnotation) || !(name = (annotationBinding = (annotation = (MarkerAnnotation)modifier).resolveAnnotationBinding()).getName()).equals(NullAnnotationsFix.getNonNullAnnotationName(this.fCompilationUnit.getJavaElement(), true))) continue;
                    astRewrite.remove((ASTNode)annotation, group);
                }
            } else {
                if (!(selectedNode instanceof Annotation)) {
                    return;
                }
                Annotation annotation = (Annotation)selectedNode;
                IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                String name = annotationBinding.getName();
                if (name.equals(NullAnnotationsFix.getNonNullByDefaultAnnotationName(this.fCompilationUnit.getJavaElement(), true))) {
                    astRewrite.remove((ASTNode)annotation, group);
                }
            }
        }
    }

    static class ReturnAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private final MethodDeclaration fBodyDeclaration;

        ReturnAnnotationRewriteOperation(MethodDeclaration method, String message, Builder builder) {
            super(builder);
            this.fKey = String.valueOf(method.resolveBinding().getKey()) + "<return>";
            this.fBodyDeclaration = method;
            this.fMessage = message;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group;
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = this.getAnnotationListRewrite(this.fBodyDeclaration.getReturnType2(), cuRewrite, (ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            if (!this.checkExisting(listRewrite, group = this.createTextEditGroup(this.fMessage, cuRewrite))) {
                return;
            }
            if (!this.fRequireExplicitAnnotation && (this.fUseNullTypeAnnotations ? this.hasNonNullDefault308((IBinding)this.fBodyDeclaration.resolveBinding(), -1, DefaultLocation.RETURN_TYPE, false) : this.hasNonNullDefault((IBinding)this.fBodyDeclaration.resolveBinding()))) {
                return;
            }
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
            newAnnotation.setTypeName(ast.newName(resolvableName));
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }
    }

    static abstract class SignatureAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        protected CompilationUnit fUnit;
        protected String fAnnotationToAdd;
        protected String fAnnotationToRemove;
        protected boolean fAllowRemove;
        protected boolean fUseNullTypeAnnotations;
        protected boolean fRequireExplicitAnnotation;
        protected String fKey;
        protected String fMessage;
        boolean fRemoveIfNonNullByDefault;
        String fNonNullByDefaultName;

        protected SignatureAnnotationRewriteOperation(Builder builder) {
            this.fUnit = builder.fUnit;
            this.fAnnotationToAdd = builder.fAnnotationToAdd;
            this.fAnnotationToRemove = builder.fAnnotationToRemove;
            this.fAllowRemove = builder.fAllowRemove;
            this.fUseNullTypeAnnotations = builder.fUseNullTypeAnnotations;
            this.fRequireExplicitAnnotation = builder.requiresExplicitAnnotation();
        }

        public String getKey() {
            return this.fKey;
        }

        public CompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        protected ListRewrite getAnnotationListRewrite(Type type, CompilationUnitRewrite cuRewrite, ASTNode declaration, ChildListPropertyDescriptor declAnnotationsProperty) {
            List dimensions;
            if (this.fUseNullTypeAnnotations && type.isArrayType() && !(dimensions = ((ArrayType)type).dimensions()).isEmpty()) {
                Dimension outerDim = (Dimension)dimensions.get(0);
                return cuRewrite.getASTRewrite().getListRewrite((ASTNode)outerDim, Dimension.ANNOTATIONS_PROPERTY);
            }
            return cuRewrite.getASTRewrite().getListRewrite(declaration, declAnnotationsProperty);
        }

        boolean checkExisting(ListRewrite listRewrite, TextEditGroup editGroup) {
            List existingModifiers = listRewrite.getOriginalList();
            for (Object mod : existingModifiers) {
                if (!(mod instanceof MarkerAnnotation)) continue;
                MarkerAnnotation annotation = (MarkerAnnotation)mod;
                String existingName = annotation.getTypeName().getFullyQualifiedName();
                int lastDot = this.fAnnotationToRemove.lastIndexOf(46);
                if (existingName.equals(this.fAnnotationToRemove) || lastDot != -1 && this.fAnnotationToRemove.substring(lastDot + 1).equals(existingName)) {
                    if (!this.fAllowRemove) {
                        return false;
                    }
                    listRewrite.remove((ASTNode)annotation, editGroup);
                    return true;
                }
                lastDot = this.fAnnotationToAdd.lastIndexOf(46);
                if (!existingName.equals(this.fAnnotationToAdd) && (lastDot == -1 || !this.fAnnotationToAdd.substring(lastDot + 1).equals(existingName))) continue;
                return false;
            }
            return true;
        }

        boolean hasNonNullDefault(IBinding enclosingElement) {
            if (!this.fRemoveIfNonNullByDefault) {
                return false;
            }
            IAnnotationBinding[] annotations = enclosingElement.getAnnotations();
            int i = 0;
            while (i < annotations.length) {
                IAnnotationBinding annot = annotations[i];
                if (annot.getAnnotationType().getQualifiedName().equals(this.fNonNullByDefaultName)) {
                    IMemberValuePairBinding[] pairs = annot.getDeclaredMemberValuePairs();
                    if (pairs.length > 0) {
                        int j = 0;
                        while (j < pairs.length) {
                            if (pairs[j].getKey() == null || pairs[j].getKey().equals("value")) {
                                return pairs[j].getValue() != Boolean.FALSE;
                            }
                            ++j;
                        }
                    }
                    return true;
                }
                ++i;
            }
            if (enclosingElement instanceof IMethodBinding) {
                return this.hasNonNullDefault((IBinding)((IMethodBinding)enclosingElement).getDeclaringClass());
            }
            if (enclosingElement instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)enclosingElement;
                if (typeBinding.isLocal()) {
                    return this.hasNonNullDefault((IBinding)typeBinding.getDeclaringMethod());
                }
                if (typeBinding.isMember()) {
                    return this.hasNonNullDefault((IBinding)typeBinding.getDeclaringClass());
                }
                return this.hasNonNullDefault((IBinding)typeBinding.getPackage());
            }
            return false;
        }

        boolean hasNonNullDefault308(IBinding enclosingElement, int parameterRank, DefaultLocation defaultLocation, boolean recursiveCall) {
            if (!this.fRemoveIfNonNullByDefault) {
                return false;
            }
            if (!recursiveCall) {
                ITypeBinding affectedType = null;
                if (enclosingElement instanceof IMethodBinding) {
                    switch (defaultLocation) {
                        case RETURN_TYPE: {
                            affectedType = ((IMethodBinding)enclosingElement).getReturnType();
                            break;
                        }
                        case PARAMETER: {
                            affectedType = ((IMethodBinding)enclosingElement).getParameterTypes()[parameterRank];
                        }
                    }
                } else if (enclosingElement instanceof IVariableBinding) {
                    affectedType = ((IVariableBinding)enclosingElement).getType();
                }
                if (affectedType != null && (affectedType.isTypeVariable() || affectedType.isWildcardType())) {
                    return false;
                }
            }
            IAnnotationBinding[] annotations = enclosingElement.getAnnotations();
            int i = 0;
            while (i < annotations.length) {
                IAnnotationBinding annot = annotations[i];
                ITypeBinding annotationType = annot.getAnnotationType();
                if (annotationType != null && annotationType.getQualifiedName().equals(this.fNonNullByDefaultName)) {
                    IMemberValuePairBinding[] pairs = annot.getDeclaredMemberValuePairs();
                    if (pairs.length > 0) {
                        int j = 0;
                        while (j < pairs.length) {
                            if (pairs[j].getKey() == null || pairs[j].getKey().equals("value")) {
                                return this.matchesLocation(pairs[j].getValue(), defaultLocation);
                            }
                            ++j;
                        }
                    }
                    return true;
                }
                ++i;
            }
            if (enclosingElement instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)enclosingElement;
                enclosingElement = variable.isParameter() ? variable.getDeclaringMethod() : variable.getDeclaringClass();
                return this.hasNonNullDefault308(enclosingElement, -1, defaultLocation, true);
            }
            if (enclosingElement instanceof IMethodBinding) {
                return this.hasNonNullDefault308((IBinding)((IMethodBinding)enclosingElement).getDeclaringClass(), -1, defaultLocation, true);
            }
            if (enclosingElement instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)enclosingElement;
                if (typeBinding.isLocal()) {
                    return this.hasNonNullDefault308((IBinding)typeBinding.getDeclaringMethod(), -1, defaultLocation, true);
                }
                if (typeBinding.isMember()) {
                    return this.hasNonNullDefault308((IBinding)typeBinding.getDeclaringClass(), -1, defaultLocation, true);
                }
                return this.hasNonNullDefault308((IBinding)typeBinding.getPackage(), -1, defaultLocation, true);
            }
            return false;
        }

        private boolean matchesLocation(Object value, DefaultLocation location) {
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                int i = 0;
                while (i < values.length) {
                    if (this.matchesLocation(values[i], location)) {
                        return true;
                    }
                    ++i;
                }
            } else if (value instanceof IVariableBinding) {
                String name = ((IVariableBinding)value).getName();
                return location.name().equals(name);
            }
            return false;
        }

        public String getMessage() {
            return this.fMessage;
        }
    }
}

