/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;

public final class ViewportUtilities {
    private ViewportUtilities() {
    }

    public static List getEnclosingViewportsPath(IFigure figure) {
        Viewport nearestEnclosingViewport = ViewportUtilities.getNearestEnclosingViewport(figure);
        if (nearestEnclosingViewport == null) {
            return new ArrayList();
        }
        Viewport rootViewport = ViewportUtilities.getRootViewport(figure);
        return ViewportUtilities.getViewportsPath(nearestEnclosingViewport, rootViewport, true);
    }

    public static List getViewportsPath(Viewport leafViewport, Viewport rootViewport) {
        return ViewportUtilities.getViewportsPath(leafViewport, rootViewport, true);
    }

    public static List getViewportsPath(Viewport leafViewport, Viewport rootViewport, boolean includeRootViewport) {
        if (leafViewport == null || rootViewport == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Viewport> nestedViewports = new ArrayList<Viewport>();
        Viewport currentViewport = leafViewport;
        do {
            nestedViewports.add(currentViewport);
        } while ((currentViewport = ViewportUtilities.getNearestEnclosingViewport(currentViewport)) != null && currentViewport != rootViewport);
        if (currentViewport != null) {
            if (includeRootViewport) {
                nestedViewports.add(currentViewport);
            }
            return nestedViewports;
        }
        return Collections.EMPTY_LIST;
    }

    public static Viewport getNearestCommonViewport(IFigure firstFigure, IFigure secondFigure) {
        return ViewportUtilities.getNearestViewport(FigureUtilities.findCommonAncestor(firstFigure, secondFigure));
    }

    public static Viewport getRootViewport(IFigure figure) {
        Viewport currentViewport = ViewportUtilities.getNearestViewport(figure);
        while (ViewportUtilities.getNearestEnclosingViewport(currentViewport) != null) {
            currentViewport = ViewportUtilities.getNearestEnclosingViewport(currentViewport);
        }
        return currentViewport;
    }

    public static Viewport getNearestViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        if (figure instanceof Viewport) {
            return (Viewport)figure;
        }
        return ViewportUtilities.getNearestEnclosingViewport(figure);
    }

    public static Viewport getNearestEnclosingViewport(IFigure figure) {
        if (figure == null) {
            return null;
        }
        Viewport viewport = null;
        IFigure currentFigure = figure;
        while (currentFigure.getParent() != null) {
            if (currentFigure.getParent() instanceof Viewport) {
                viewport = (Viewport)currentFigure.getParent();
                break;
            }
            currentFigure = currentFigure.getParent();
        }
        return viewport;
    }
}

