/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.flatui;

import org.eclipse.bpel.common.ui.flatui.BorderData;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;

public final class FlatFormData
extends BorderData {
    public int height;
    public int width;
    public FlatFormAttachment left;
    public FlatFormAttachment right;
    public FlatFormAttachment top;
    public FlatFormAttachment bottom;
    int cacheHeight;
    int cacheWidth;
    boolean isVisited;

    public FlatFormData() {
        this(-1, -1);
    }

    public FlatFormData(int width, int height) {
        this.width = width;
        this.height = height;
    }

    FlatFormAttachment getBottomAttachment() {
        if (this.isVisited) {
            return new FlatFormAttachment(0, this.cacheHeight);
        }
        if (this.bottom == null) {
            if (this.top == null) {
                return new FlatFormAttachment(0, this.cacheHeight);
            }
            return this.getTopAttachment().plus(this.cacheHeight);
        }
        if (this.bottom.control == null) {
            return this.bottom;
        }
        this.isVisited = true;
        FlatFormData bottomData = (FlatFormData)this.bottom.control.getLayoutData();
        FlatFormAttachment topAttachment = bottomData.getTopAttachment();
        FlatFormAttachment bottomAttachment = bottomData.getBottomAttachment();
        this.isVisited = false;
        if (this.bottom.alignment == 1024) {
            return bottomAttachment.plus(this.bottom.offset);
        }
        if (this.bottom.alignment == 0x1000000) {
            FlatFormAttachment bottomHeight = bottomAttachment.minus(topAttachment);
            return bottomAttachment.minus(bottomHeight.minus(this.cacheHeight).divide(2));
        }
        return topAttachment.plus(this.bottom.offset);
    }

    FlatFormAttachment getLeftAttachment() {
        if (this.isVisited) {
            return new FlatFormAttachment(0, 0);
        }
        if (this.left == null) {
            if (this.right == null) {
                return new FlatFormAttachment(0, 0);
            }
            return this.getRightAttachment().minus(this.cacheWidth);
        }
        if (this.left.control == null) {
            return this.left;
        }
        this.isVisited = true;
        FlatFormData leftData = (FlatFormData)this.left.control.getLayoutData();
        FlatFormAttachment rightAttachment = leftData.getRightAttachment();
        FlatFormAttachment leftAttachment = leftData.getLeftAttachment();
        this.isVisited = false;
        if (this.left.alignment == 16384) {
            return leftAttachment.plus(this.left.offset);
        }
        if (this.left.alignment == 0x1000000) {
            FlatFormAttachment leftWidth = rightAttachment.minus(leftAttachment);
            return leftAttachment.plus(leftWidth.minus(this.cacheWidth).divide(2));
        }
        return rightAttachment.plus(this.left.offset);
    }

    FlatFormAttachment getRightAttachment() {
        if (this.isVisited) {
            return new FlatFormAttachment(0, this.cacheWidth);
        }
        if (this.right == null) {
            if (this.left == null) {
                return new FlatFormAttachment(0, this.cacheWidth);
            }
            return this.getLeftAttachment().plus(this.cacheWidth);
        }
        if (this.right.control == null) {
            return this.right;
        }
        this.isVisited = true;
        FlatFormData rightData = (FlatFormData)this.right.control.getLayoutData();
        FlatFormAttachment leftAttachment = rightData.getLeftAttachment();
        FlatFormAttachment rightAttachment = rightData.getRightAttachment();
        this.isVisited = false;
        if (this.right.alignment == 131072) {
            return rightAttachment.plus(this.right.offset);
        }
        if (this.right.alignment == 0x1000000) {
            FlatFormAttachment rightWidth = rightAttachment.minus(leftAttachment);
            return rightAttachment.minus(rightWidth.minus(this.cacheWidth).divide(2));
        }
        return leftAttachment.plus(this.right.offset);
    }

    FlatFormAttachment getTopAttachment() {
        if (this.isVisited) {
            return new FlatFormAttachment(0, 0);
        }
        if (this.top == null) {
            if (this.bottom == null) {
                return new FlatFormAttachment(0, 0);
            }
            return this.getBottomAttachment().minus(this.cacheHeight);
        }
        if (this.top.control == null) {
            return this.top;
        }
        this.isVisited = true;
        FlatFormData topData = (FlatFormData)this.top.control.getLayoutData();
        FlatFormAttachment topAttachment = topData.getTopAttachment();
        FlatFormAttachment bottomAttachment = topData.getBottomAttachment();
        this.isVisited = false;
        if (this.top.alignment == 128) {
            return topAttachment.plus(this.top.offset);
        }
        if (this.top.alignment == 0x1000000) {
            FlatFormAttachment topHeight = bottomAttachment.minus(topAttachment);
            return topAttachment.plus(topHeight.minus(this.cacheHeight).divide(2));
        }
        return bottomAttachment.plus(this.top.offset);
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName()) + " {";
        if (this.width != 0) {
            string = String.valueOf(string) + "w=" + this.width + " ";
        }
        if (this.height != 0) {
            string = String.valueOf(string) + "h=" + this.height + " ";
        }
        if (this.left != null) {
            string = String.valueOf(string) + "L=(" + this.left + ") ";
        }
        if (this.right != null) {
            string = String.valueOf(string) + "R=(" + this.right + ") ";
        }
        if (this.top != null) {
            string = String.valueOf(string) + "T=(" + this.top + ") ";
        }
        if (this.bottom != null) {
            string = String.valueOf(string) + "B=(" + this.bottom + ") ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

