/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.ProjectFileDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ResourceFilterDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProjectFilterAction
extends Action {
    private static final String ACTION_TEXT = Messages.getString((String)"ProjectFilterAction.text");
    private ProjectFileDialog dialog;

    public ProjectFilterAction(ProjectFileDialog dialog) {
        super(ACTION_TEXT);
        this.dialog = dialog;
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("resource filter"));
        this.setToolTipText(ACTION_TEXT);
    }

    public void run() {
        ResourceFilterDialog dialog = new ResourceFilterDialog();
        ArrayList<ResourceFilter> filters = new ArrayList<ResourceFilter>();
        filters.addAll(ReportPlugin.getFilterMap().values());
        dialog.setInput(filters);
        if (dialog.open() == 0) {
            IPreferenceStore store = ReportPlugin.getDefault().getPreferenceStore();
            int i = 0;
            while (i < filters.size()) {
                ResourceFilter filter = (ResourceFilter)filters.get(i);
                store.setValue(filter.getType(), filter.isEnabled());
                ++i;
            }
        }
        this.dialog.refreshRoot();
    }
}

