/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfo;
import org.eclipse.birt.data.engine.olap.cursor.ResultSetFetcher;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.cursor.Section;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

class EdgeDimensionRelation {
    List[] currentRelation;
    int traverseLength;
    ResultSetFetcher fetcher;
    private List sectionList;

    EdgeDimensionRelation(RowDataAccessorService service, ResultSetFetcher fetcher, boolean isPage) throws IOException {
        IAggregationResultSet rs = fetcher.getAggrResultSet();
        DimensionAxis[] dimAxis = service.getDimensionAxis();
        this.sectionList = new ArrayList();
        this.fetcher = fetcher;
        int customDimSize = dimAxis.length;
        this.traverseLength = rs.length();
        Object[] preValue = new Object[customDimSize];
        Object[] currValue = new Object[customDimSize];
        Section section = null;
        boolean newSection = true;
        int startId = 0;
        if (this.traverseLength == 0) {
            section = new Section(customDimSize, -1, -1);
            this.sectionList.add(section);
            this.currentRelation = ((Section)this.sectionList.get(0)).getRelation();
        } else {
            int rowId = 0;
            while (rowId < this.traverseLength) {
                int breakLevel;
                rs.seek(rowId);
                int i = 0;
                while (i < customDimSize) {
                    if (fetcher.getLevelKeyValue(service.getDimensionAxis()[i].getLevelIndex()) == null) {
                        currValue[i] = null;
                    } else {
                        int index = fetcher.getAggrResultSet().getLevelKeyColCount(service.getDimensionAxis()[i].getLevelIndex()) - 1;
                        currValue[i] = fetcher.getLevelKeyValue(service.getDimensionAxis()[i].getLevelIndex())[index];
                    }
                    ++i;
                }
                if (newSection) {
                    section = new Section(customDimSize, -1, -1);
                    newSection = false;
                    this.sectionList.add(section);
                    breakLevel = 0;
                } else {
                    breakLevel = this.getBreakLevel(currValue, preValue, section, rowId);
                    if (breakLevel <= service.getPagePosition() && !isPage) {
                        section.setBaseStart(startId);
                        section.setBaseEnd(rowId - 1);
                        startId = rowId--;
                        newSection = true;
                    }
                }
                if (!newSection) {
                    int level = breakLevel;
                    while (level < customDimSize) {
                        EdgeInfo edge = new EdgeInfo();
                        if (currValue[level] == null) {
                            edge.isNull = 0;
                        }
                        if (level != 0) {
                            edge.parent = section.getRelation()[level - 1].size() - 1;
                        }
                        edge.firstChild = level == section.getRelation().length - 1 ? rowId : section.getRelation()[level + 1].size();
                        section.getRelation()[level].add(edge);
                        ++level;
                    }
                    int i2 = 0;
                    while (i2 < customDimSize) {
                        preValue[i2] = currValue[i2];
                        ++i2;
                    }
                }
                ++rowId;
            }
            section.setBaseStart(startId);
            section.setBaseEnd(this.traverseLength - 1);
            this.currentRelation = ((Section)this.sectionList.get(0)).getRelation();
            this.traverseLength = ((Section)this.sectionList.get(0)).getBaseEnd() - ((Section)this.sectionList.get(0)).getBaseStart() + 1;
        }
    }

    private int getBreakLevel(Object[] currValue, Object[] preValue, Section section, int rowId) {
        assert (preValue != null && currValue != null);
        int breakLevel = 0;
        while (breakLevel < currValue.length) {
            List list = section.getRelation()[breakLevel];
            EdgeInfo edgeInfo = (EdgeInfo)list.get(list.size() - 1);
            int child = edgeInfo.firstChild;
            Object currObjectValue = currValue[breakLevel];
            Object prevObjectValue = preValue[breakLevel];
            int level = breakLevel + 1;
            while (level < section.getRelation().length) {
                list = section.getRelation()[level];
                edgeInfo = (EdgeInfo)list.get(child);
                child = edgeInfo.firstChild;
                ++level;
            }
            if (!this.isEqualObject(currObjectValue, prevObjectValue)) break;
            ++breakLevel;
        }
        return breakLevel;
    }

    public void synchronizedWithPage(int position) {
        if (this.sectionList.size() > position) {
            this.currentRelation = ((Section)this.sectionList.get(position)).getRelation();
            this.traverseLength = ((Section)this.sectionList.get(position)).getBaseEnd() - ((Section)this.sectionList.get(position)).getBaseStart() + 1;
        }
    }

    private boolean isEqualObject(Object preValue, Object currentValue) {
        if (preValue == currentValue) {
            return true;
        }
        if (preValue == null || currentValue == null) {
            return false;
        }
        return preValue.equals(currentValue);
    }
}

