/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.editor;

import net.sourceforge.nattable.edit.editor.AbstractCellEditor;
import net.sourceforge.nattable.painter.cell.CheckBoxPainter;
import net.sourceforge.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckBoxCellEditor
extends AbstractCellEditor {
    private boolean checked;
    private Canvas canvas;
    private final CheckBoxPainter checkBoxCellPainter;

    public CheckBoxCellEditor() {
        this.checkBoxCellPainter = new CheckBoxPainter();
    }

    public CheckBoxCellEditor(Image checkedImg, Image uncheckedImg) {
        this.checkBoxCellPainter = new CheckBoxPainter(checkedImg, uncheckedImg);
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.setCanonicalValue(originalCanonicalValue);
        this.checked = !this.checked;
        this.canvas = new Canvas(parent, 0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle bounds = CheckBoxCellEditor.this.canvas.getBounds();
                Rectangle rect = new Rectangle(0, 0, bounds.width, bounds.height);
                CheckBoxCellEditor.this.checkBoxCellPainter.paintIconImage(paintEvent.gc, rect, bounds.height / 2 - CheckBoxCellEditor.this.checkBoxCellPainter.getPreferredHeight(CheckBoxCellEditor.this.checked) / 2, CheckBoxCellEditor.this.checked);
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CheckBoxCellEditor.this.checked = !CheckBoxCellEditor.this.checked;
                CheckBoxCellEditor.this.canvas.redraw();
            }
        });
        this.commit(SelectionLayer.MoveDirectionEnum.NONE, false);
        return this.canvas;
    }

    public Object getCanonicalValue() {
        return this.getDataTypeConverter().displayToCanonicalValue(this.checked);
    }

    public void setCanonicalValue(Object canonicalValue) {
        this.checked = canonicalValue == null ? false : Boolean.valueOf((String)this.getDataTypeConverter().canonicalToDisplayValue(canonicalValue));
    }

    public void close() {
        super.close();
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }
}

