/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.internal.listener;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.tcf.core.util.JSONUtils;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.log.core.events.MonitorEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.nls.Messages;
import org.eclipse.tcf.te.tcf.log.core.manager.LogManager;

public final class ChannelTraceListener
implements AbstractChannel.TraceListener {
    public final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    final IChannel channel;
    final String logname;
    final boolean reverseReceived;

    public ChannelTraceListener(String logname, IChannel channel) {
        this.logname = logname;
        Assert.isNotNull((Object)channel);
        this.channel = channel;
        this.reverseReceived = channel.getRemotePeer().getName() != null && channel.getRemotePeer().getName().endsWith("Command Server");
    }

    protected final IChannel getChannel() {
        return this.channel;
    }

    public void onChannelClosed(final Throwable error) {
        IPeer peer;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onChannelClosed ( " + error + " )", "trace/channelTraceListener", (Object)this);
        }
        if ((peer = this.channel.getRemotePeer()) == null) {
            return;
        }
        final String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String message = NLS.bind((String)Messages.ChannelTraceListener_channelClosed_message, (Object[])new Object[]{date, Integer.toHexString(ChannelTraceListener.this.channel.hashCode()), error});
                FileWriter writer = LogManager.getInstance().getWriter(ChannelTraceListener.this.logname, peer);
                if (writer != null) {
                    try {
                        writer.write(message);
                        writer.write("\n");
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                LogManager.getInstance().monitor(peer, MonitorEvent.Type.CLOSE, new MonitorEvent.Message('F', message));
            }
        });
    }

    public void onMessageReceived(final char type, final String token, final String service, final String name, final byte[] data) {
        IPeer peer;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onMessageReceived ( " + type + ", " + token + ", " + service + ", " + name + ", ... )", "trace/channelTraceListener", (Object)this);
        }
        if ((peer = this.channel.getRemotePeer()) == null) {
            return;
        }
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ChannelTraceListener.this.doLogMessage(peer, type, token, service, name, data, !ChannelTraceListener.this.reverseReceived);
            }
        });
    }

    public void onMessageSent(final char type, final String token, final String service, final String name, final byte[] data) {
        IPeer peer;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelTraceListener")) {
            CoreBundleActivator.getTraceHandler().trace("TraceListener.onMessageSent ( " + type + ", " + token + ", " + service + ", " + name + ", ... )", "trace/channelTraceListener", (Object)this);
        }
        if ((peer = this.channel.getRemotePeer()) == null) {
            return;
        }
        ExecutorsUtil.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ChannelTraceListener.this.doLogMessage(peer, type, token, service, name, data, ChannelTraceListener.this.reverseReceived);
            }
        });
    }

    void doLogMessage(IPeer peer, char type, String token, String service, String name, byte[] data, boolean received) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)ExecutorsUtil.isExecutorThread(), (String)"Illegal Thread Access");
        boolean locatorEvents = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.locatorEvents");
        if (!locatorEvents && service != null && service.toLowerCase().equals("locator")) {
            return;
        }
        boolean showHeartbeats = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.heartbeats");
        if (!showHeartbeats && name != null && name.toLowerCase().contains("heartbeat")) {
            return;
        }
        boolean frameworkEvents = CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.show.frameworkEvents");
        if (!frameworkEvents && type == 'F') {
            return;
        }
        String args = JSONUtils.decodeStringFromByteArray((byte[])data);
        if (type == 'C' && "Diagnostics".equals(service) && "echo".equals(name) && "\"ping\"".equals(args) || type == 'R' && service == null && name == null && "\"ping\"".equals(args)) {
            return;
        }
        String message = this.formatMessage(type, token, service, name, args, received);
        FileWriter writer = LogManager.getInstance().getWriter(this.logname, peer);
        if (writer != null) {
            try {
                writer.write(message);
                writer.write("\n");
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LogManager.getInstance().monitor(peer, MonitorEvent.Type.ACTIVITY, new MonitorEvent.Message(type, message));
    }

    private String formatMessage(char type, String token, String service, String name, String args, boolean received) {
        String time = this.TIME_FORMAT.format(new Date(System.currentTimeMillis()));
        StringBuilder message = new StringBuilder();
        message.append(time).append(":");
        message.append(" [").append(Integer.toHexString(this.channel.hashCode())).append("]");
        message.append(" ").append(received ? "<---" : "--->");
        message.append(" ").append(Character.valueOf(type));
        if (token != null) {
            message.append(" ").append(token);
        }
        if (service != null) {
            message.append(" ").append(service);
        }
        if (name != null) {
            message.append(" ").append(name);
        }
        if (args != null && args.trim().length() > 0) {
            message.append(" ").append(args.trim());
        }
        return message.toString();
    }
}

