/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.outline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationPresenterExtension;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SiriusInformationPresenter
extends AbstractInformationControlManager
implements IInformationPresenter,
IInformationPresenterExtension {
    private Map fProviders;
    private int fOffset = -1;
    private String fPartitioning;

    public SiriusInformationPresenter(IInformationControlCreator creator) {
        super(creator);
        this.setCloser(new Closer());
        this.takesFocusWhenVisible(true);
        this.fPartitioning = "__dftl_partitioning";
    }

    public void setDocumentPartitioning(String partitioning) {
        Assert.isNotNull((Object)partitioning);
        this.fPartitioning = partitioning;
    }

    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setInformationProvider(IInformationProvider provider, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fProviders == null) {
            this.fProviders = new HashMap();
        }
        if (provider == null) {
            this.fProviders.remove(contentType);
        } else {
            this.fProviders.put(contentType, provider);
        }
    }

    public IInformationProvider getInformationProvider(String contentType) {
        if (this.fProviders == null) {
            return null;
        }
        return (IInformationProvider)this.fProviders.get(contentType);
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    protected void computeInformation() {
        int offset = this.fOffset = -1;
        IInformationProvider provider = null;
        provider = this.getInformationProvider("__dftl_partition_content_type");
        if (provider == null) {
            return;
        }
        IRegion subject = provider.getSubject(null, offset);
        if (subject == null) {
            return;
        }
        if (provider instanceof IInformationProviderExtension2) {
            this.setCustomInformationControlCreator(((IInformationProviderExtension2)provider).getInformationPresenterControlCreator());
        } else {
            this.setCustomInformationControlCreator(null);
        }
        if (provider instanceof IInformationProviderExtension) {
            IInformationProviderExtension extension = (IInformationProviderExtension)provider;
            this.setInformation(extension.getInformation2(null, subject), this.computeArea(subject));
        } else {
            this.setInformation(provider.getInformation(null, subject), this.computeArea(subject));
        }
    }

    private Rectangle computeArea(IRegion region) {
        return new Rectangle(0, 0, 0, 0);
    }

    public void install(ITextViewer textViewer) {
    }

    public void uninstall() {
        this.dispose();
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    FocusListener,
    IViewportListener,
    KeyListener {
        private Control fSubjectControl;
        private IInformationControl fInformationControlToClose;
        private boolean fIsActive;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
            this.fInformationControlToClose = control;
        }

        public void start(Rectangle informationArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addFocusListener((FocusListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.addFocusListener((FocusListener)this);
            }
        }

        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.removeFocusListener((FocusListener)this);
            }
            SiriusInformationPresenter.this.hideInformationControl();
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeFocusListener((FocusListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
        }

        public void controlResized(ControlEvent e) {
            this.stop();
        }

        public void controlMoved(ControlEvent e) {
            this.stop();
        }

        public void mouseDown(MouseEvent e) {
            this.stop();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.stop();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Closer.this.fInformationControlToClose == null || !Closer.this.fInformationControlToClose.isFocusControl()) {
                        Closer.this.stop();
                    }
                }
            });
        }

        public void viewportChanged(int topIndex) {
            this.stop();
        }

        public void keyPressed(KeyEvent e) {
            this.stop();
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

