/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.report.TestSuite;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="create_report")
@Category(value="__hidden__")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/extendingmat.html")
@Icon(value="/META-INF/icons/expert.gif")
public class RunExternalTest
implements IQuery {
    @Argument
    public IQueryContext context;
    @Argument(flag="none")
    public File testSuite;
    @Argument(isMandatory=false)
    public String[] params;

    @Override
    public IResult execute(IProgressListener listener) throws Exception {
        Spec template;
        try {
            SpecFactory factory = SpecFactory.instance();
            template = factory.create(this.testSuite);
            Map<String, String> opts = this.parseOptions(this.params);
            template.putAll(opts);
            factory.resolve(template);
        }
        catch (Exception e) {
            throw new SnapshotException(e);
        }
        TestSuite suite = new TestSuite.Builder(template).build(this.context);
        suite.execute(listener);
        for (File f : suite.getResults()) {
            if (!"index.html".equals(f.getName())) continue;
            return new DisplayFileResult(f);
        }
        return null;
    }

    Map<String, String> parseOptions(String[] opts) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (opts != null) {
            String[] stringArray = opts;
            int n = opts.length;
            int n2 = 0;
            while (n2 < n) {
                String opt = stringArray[n2];
                int i = opt.indexOf(61);
                if (i < 0) {
                    throw new IllegalArgumentException(opt);
                }
                m.put(opt.substring(0, i), opt.substring(i + 1));
                ++n2;
            }
        }
        return m;
    }
}

