/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.beaninfo.adapters.IReader;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoPlugin;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeaninfoEntry
implements IBeaninfosDocEntry {
    static final String sBeaninfo = "beaninfo";
    public static final int BIE_PLUGIN = 100;
    protected IClasspathEntry entry;
    protected IPath pluginPath;
    protected boolean isExported;
    protected SearchpathEntry[] searchpaths;

    static int kindFromString(String kindStr) {
        if (kindStr == null || kindStr.length() == 0) {
            return 100;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("plugin")) {
            return 100;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 100: {
                return "plugin";
            }
        }
        return "unknown";
    }

    public static IClasspathEntry createEntry(int kind, IPath path, IProject project, boolean isExported) {
        switch (kind) {
            case 1: {
                if (!path.isAbsolute()) break;
                return JavaCore.newLibraryEntry((IPath)path, null, null, (boolean)isExported);
            }
            case 3: {
                if (!path.isAbsolute()) break;
                String projSegment = path.segment(0);
                if (project != null && projSegment != null && projSegment.equals(project.getName())) {
                    return JavaCore.newSourceEntry((IPath)path);
                }
                return JavaCore.newProjectEntry((IPath)path, (boolean)isExported);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, null, null, (boolean)isExported);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path, (boolean)isExported);
            }
        }
        return null;
    }

    public static BeaninfoEntry readEntry(IReader reader, Object element, IProject project) {
        String elementKind = reader.getAttribute(element, "kind");
        String pathStr = reader.getAttribute(element, "path");
        Path path = new Path(pathStr);
        int kind = BeaninfoEntry.kindFromString(elementKind);
        if (kind != 4 && kind != 5 && kind != 100 && !path.isAbsolute()) {
            path = project != null ? project.getFullPath().append((IPath)path) : path.makeAbsolute();
        }
        String exportedString = reader.getAttribute(element, "exported");
        boolean isExported = "true".equalsIgnoreCase(exportedString);
        IClasspathEntry cpEntry = null;
        Path pluginPath = null;
        if (kind != 100) {
            cpEntry = BeaninfoEntry.createEntry(kind, (IPath)path, project, isExported);
        } else if (path.isAbsolute()) {
            pluginPath = path;
        } else if (element instanceof IConfigurationElement) {
            pluginPath = new Path(String.valueOf('/') + ((IConfigurationElement)element).getDeclaringExtension().getContributor().getName()).append((IPath)path);
        } else {
            return null;
        }
        ArrayList<SearchpathEntry> searchpaths = new ArrayList<SearchpathEntry>();
        Object children = reader.getChildren(element);
        int childrenLength = reader.getLength(children);
        int i = 0;
        while (i < childrenLength) {
            Object child = reader.getItem(children, i);
            if (reader.isNodeTypeElement(child)) {
                SearchpathEntry entry = null;
                if (reader.getNodeName(child).equalsIgnoreCase("searchpath")) {
                    entry = SearchpathEntry.readEntry(reader, child, project, true);
                }
                if (entry != null) {
                    searchpaths.add(entry);
                }
            }
            ++i;
        }
        if (cpEntry != null) {
            return new BeaninfoEntry(cpEntry, searchpaths.toArray(new SearchpathEntry[searchpaths.size()]), isExported);
        }
        return new BeaninfoEntry((IPath)pluginPath, searchpaths.toArray(new SearchpathEntry[searchpaths.size()]), isExported);
    }

    public BeaninfoEntry(IPath pluginPath, SearchpathEntry[] searchpaths, boolean isExported) {
        this(searchpaths, isExported);
        this.pluginPath = pluginPath;
    }

    public BeaninfoEntry(IClasspathEntry entry, SearchpathEntry[] searchpaths, boolean isExported) {
        this(searchpaths, isExported);
        this.entry = entry;
    }

    protected BeaninfoEntry(SearchpathEntry[] searchpaths, boolean isExported) {
        this.isExported = isExported;
        this.searchpaths = searchpaths != null ? searchpaths : new SearchpathEntry[]{};
    }

    public SearchpathEntry[] getSearchPaths() {
        return this.searchpaths;
    }

    public void setSearchPaths(SearchpathEntry[] searchpaths) {
        this.searchpaths = searchpaths;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public void setIsExported(boolean isExported) {
        this.isExported = isExported;
    }

    @Override
    public Node writeEntry(Document doc, IProject project) {
        Element element = doc.createElement(sBeaninfo);
        IPath path = null;
        if (this.entry != null) {
            element.setAttribute("kind", BeaninfoEntry.kindToString(this.entry.getEntryKind()));
            path = this.entry.getPath();
            if (this.entry.getEntryKind() != 4 && this.entry.getEntryKind() != 5 && path.isAbsolute()) {
                if (path.segment(0).equals(project.getFullPath().segment(0))) {
                    path = path.removeFirstSegments(1);
                    path = path.makeRelative();
                } else {
                    path = path.makeAbsolute();
                }
            }
        } else {
            element.setAttribute("kind", BeaninfoEntry.kindToString(100));
            path = this.pluginPath;
        }
        element.setAttribute("path", path.toString());
        if (this.isExported()) {
            element.setAttribute("exported", "true");
        }
        int i = 0;
        while (i < this.searchpaths.length) {
            SearchpathEntry spe = this.searchpaths[i];
            element.appendChild(spe.writeEntry(doc, project));
            ++i;
        }
        return element;
    }

    public IClasspathEntry getClasspathEntry() {
        return this.entry;
    }

    public Object[] getClasspath(IJavaProject javaProject) {
        if (this.entry != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList paths = new ArrayList(1);
            IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.entry);
            this.resolveEntry(root, paths, resolvedEntry, javaProject);
            return paths.toArray();
        }
        if (this.pluginPath != null) {
            return new Object[]{this.pluginPath};
        }
        return null;
    }

    private void resolveEntry(IWorkspaceRoot root, List paths, IClasspathEntry entry, IJavaProject javaProject) {
        switch (entry.getEntryKind()) {
            case 2: {
                IProject reqProject = (IProject)root.findMember(entry.getPath().lastSegment());
                if (reqProject == null || !reqProject.isOpen()) break;
                paths.add(reqProject);
                break;
            }
            case 3: {
                IProject reqProject = (IProject)root.findMember(entry.getPath().segment(0));
                IJavaProject jProject = JavaCore.create((IProject)reqProject);
                if (jProject == null) break;
                try {
                    IPath outputLocation = jProject.getOutputLocation();
                    IResource resource = root.findMember(outputLocation);
                    if (resource == null) break;
                    paths.add(resource.getLocation().toString());
                }
                catch (JavaModelException javaModelException) {}
                break;
            }
            case 1: {
                IResource library = root.findMember(entry.getPath());
                paths.add(library != null ? library.getLocation().toString() : entry.getPath().toString());
                break;
            }
            case 5: {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                    if (container == null) break;
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        this.resolveEntry(root, paths, entries[i], javaProject);
                        ++i;
                    }
                    break;
                }
                catch (JavaModelException e) {
                    BeaninfoPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                }
            }
        }
    }

    @Override
    public int getKind() {
        return this.entry != null ? this.entry.getEntryKind() : 100;
    }

    @Override
    public IPath getPath() {
        return this.entry != null ? this.entry.getPath() : this.pluginPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeaninfoEntry)) {
            return false;
        }
        BeaninfoEntry otherEntry = (BeaninfoEntry)other;
        if (this.isExported != otherEntry.isExported) {
            return false;
        }
        if (this.entry != null) {
            return this.entry.equals(otherEntry.entry);
        }
        return this.pluginPath.equals((Object)otherEntry.pluginPath);
    }

    public int hashCode() {
        if (this.entry != null) {
            return this.entry.hashCode() ^ (this.isExported ? Boolean.TRUE : Boolean.FALSE).hashCode();
        }
        return this.pluginPath.hashCode() ^ (this.isExported ? Boolean.TRUE : Boolean.FALSE).hashCode();
    }
}

