/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.launch;

import java.io.File;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gprof.launch.GprofLaunchMessages;
import org.eclipse.linuxtools.internal.gprof.launch.GprofNoGmonDialog;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.profiling.ui.CProjectBuildHelpers;
import org.eclipse.linuxtools.profiling.ui.MessageDialogSyncedRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GprofLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    private ILaunchConfiguration config;
    private IProject project;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        this.project = this.getProject();
        if (!this.preRequisiteCheck()) {
            return;
        }
        IPath exePath = GprofLaunchConfigurationDelegate.getExePath(config);
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.getProject());
        File workDir = this.getWorkingDirectory(config);
        if (workDir == null) {
            workDir = new File(System.getProperty("user.home", "."));
        }
        String[] arguments = this.getProgramArgumentsArray(config);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, exePath));
        Process process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)new Path(workDir.getAbsolutePath()), monitor);
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
    }

    private boolean preRequisiteCheck() {
        CProjectBuildHelpers.ProjectBuildType projectBuildType = CProjectBuildHelpers.getProjectType((IProject)this.project);
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            return this.preRequisiteCheckAutotools(projectBuildType);
        }
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            return this.preRequisiteCheckManagedBuild(projectBuildType);
        }
        return true;
    }

    private boolean preRequisiteCheckAutotools(CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String optionId = "cflags-gprof";
        if (CProjectBuildHelpers.isOptionCheckedInAutotoolsPrefStore((IProject)this.project, (String)optionId)) {
            return true;
        }
        return this.askUserAboutFlag(optionId, projectBuildType);
    }

    private boolean preRequisiteCheckManagedBuild(CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String optionId = null;
        if (CProjectBuildHelpers.isCppType((IProject)this.project)) {
            optionId = "gnu.cpp.compiler.option.debugging.gprof";
        } else if (CProjectBuildHelpers.isCType((IProject)this.project)) {
            optionId = "gnu.c.compiler.option.debugging.gprof";
        }
        if (CProjectBuildHelpers.isOptionCheckedInCDT((IProject)this.project, (String)optionId)) {
            return true;
        }
        return this.askUserAboutFlag(optionId, projectBuildType);
    }

    private boolean askUserAboutFlag(String optionID, CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        String title = GprofLaunchMessages.GprofMissingFlag_Title;
        Object msg = GprofLaunchMessages.GprofMissingFlag_Body_shared;
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            msg = (String)msg + GprofLaunchMessages.GprofMissingFlag_Body_Autotools;
        } else if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            msg = (String)msg + GprofLaunchMessages.GprofMissingFlag_Body_Managed;
        }
        msg = (String)msg + GprofLaunchMessages.GprofMissingFlag_BodyPost_autoAddFlagQuestion;
        boolean okPressed = MessageDialogSyncedRunnable.openQuestionSyncedRunnable((String)title, (String)msg);
        if (okPressed) {
            this.enablePgOption(optionID, projectBuildType);
            CProjectBuildHelpers.rebuildProject((IProject)this.project);
            return true;
        }
        return false;
    }

    private void enablePgOption(String optionId, CProjectBuildHelpers.ProjectBuildType projectBuildType) {
        if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.MANAGED_MAKEFILE) {
            CProjectBuildHelpers.setOptionInCDT((IProject)this.project, (String)optionId, (boolean)true);
        } else if (projectBuildType == CProjectBuildHelpers.ProjectBuildType.AUTO_TOOLS) {
            CProjectBuildHelpers.setOptionInAutotools((IProject)this.project, (String)optionId, (String)"true");
        }
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.gprof.launch";
    }

    private IProject getProject() {
        try {
            return CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IPath getExePath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private IPath exePath;

        public LaunchTerminationWatcher(ILaunch il, IPath exePath) {
            this.launch = il;
            this.exePath = exePath;
        }

        public void launchesTerminated(ILaunch[] launches) {
            for (ILaunch l : launches) {
                if (!l.equals((Object)this.launch)) continue;
                Display.getDefault().syncExec(() -> {
                    try {
                        IFileStore exe;
                        String s = this.exePath.toOSString();
                        RemoteProxyManager rpmgr = RemoteProxyManager.getInstance();
                        IRemoteFileProxy proxy = rpmgr.getFileProxy(GprofLaunchConfigurationDelegate.this.getProject());
                        Object gmonExpected = GprofLaunchConfigurationDelegate.this.getWorkingDirectory(GprofLaunchConfigurationDelegate.this.config).getAbsolutePath() + "/gmon.out";
                        IFileStore gmonFileStore = proxy.getResource((String)gmonExpected);
                        if (!gmonFileStore.fetchInfo().exists()) {
                            Shell parent1 = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            GprofNoGmonDialog noGmonDialog = new GprofNoGmonDialog(GprofLaunchConfigurationDelegate.this.project, parent1);
                            gmonExpected = noGmonDialog.getGmonExpected();
                            if (gmonExpected == null) {
                                return;
                            }
                            gmonFileStore = proxy.getResource((String)gmonExpected);
                        }
                        if ((exe = proxy.getResource(this.exePath.toString())).fetchInfo().getLastModified() > gmonFileStore.fetchInfo().getLastModified()) {
                            String title = GprofLaunchMessages.GprofGmonStale_msg;
                            String message = GprofLaunchMessages.GprofGmonStaleExplanation_msg;
                            Shell parent2 = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            MessageDialog.openWarning((Shell)parent2, (String)title, (String)message);
                        }
                        Display.getDefault().asyncExec((Runnable)new LaunchTerminationWatcherRunnable(s, (String)gmonExpected));
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                });
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        class LaunchTerminationWatcherRunnable
        implements Runnable {
            private String exePath;
            private String gmonPath;

            public LaunchTerminationWatcherRunnable(String exePath, String gmonPath) {
                this.exePath = exePath;
                this.gmonPath = gmonPath;
            }

            @Override
            public void run() {
                GmonView.displayGprofView((String)this.exePath, (String)this.gmonPath, (IProject)GprofLaunchConfigurationDelegate.this.getProject());
            }
        }
    }
}

