/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.ui.swt;

import org.eclipse.emf.cdo.transfer.CDOTransfer;
import org.eclipse.emf.cdo.transfer.CDOTransferMapping;
import org.eclipse.emf.cdo.transfer.ui.TransferContentProvider;
import org.eclipse.emf.cdo.transfer.ui.TransferLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TransferTreeComposite
extends Composite {
    private CDOTransfer transfer;
    private TreeViewer viewer;

    public TransferTreeComposite(Composite parent, int style, CDOTransfer transfer) {
        super(parent, style);
        this.transfer = transfer;
        this.setLayout((Layout)new FillLayout(512));
        this.viewer = new TreeViewer((Composite)this, 65536);
        Tree tree = this.viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        TreeViewerColumn sourceViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn sourceColumn = sourceViewerColumn.getColumn();
        sourceColumn.setWidth(350);
        sourceColumn.setText("From " + String.valueOf(transfer.getSourceSystem()));
        TreeViewerColumn typeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn typeColumn = typeViewerColumn.getColumn();
        typeColumn.setWidth(100);
        typeColumn.setText("Type");
        TreeViewerColumn targetViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn targetColumn = targetViewerColumn.getColumn();
        targetColumn.setWidth(450);
        targetColumn.setText("To " + String.valueOf(transfer.getTargetSystem()));
        TreeViewerColumn statusViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn statusColumn = statusViewerColumn.getColumn();
        statusColumn.setWidth(100);
        statusColumn.setText("Status");
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setContentProvider((IContentProvider)new TransferContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TransferLabelProvider(transfer));
        this.viewer.setInput((Object)transfer.getRootMapping());
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu((Control)tree);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)TransferTreeComposite.this.viewer.getSelection();
                CDOTransferMapping mapping = (CDOTransferMapping)selection.getFirstElement();
                manager.add((IAction)new UnmapAction(mapping));
            }
        });
        manager.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
    }

    public CDOTransfer getTransfer() {
        return this.transfer;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public CDOTransferMapping getSelectedMapping() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (CDOTransferMapping)selection.getFirstElement();
    }

    public boolean setFocus() {
        return this.viewer.getTree().setFocus();
    }

    public static class UnmapAction
    extends Action {
        private CDOTransferMapping mapping;

        public UnmapAction(CDOTransferMapping mapping) {
            super("Unmap", SharedIcons.getDescriptor((String)"etool16/delete"));
            this.mapping = mapping;
        }

        public CDOTransferMapping getMapping() {
            return this.mapping;
        }

        public void run() {
            this.mapping.unmap();
        }
    }
}

