/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.bind;

import java.util.Objects;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateSetStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.bind.BindingBuilder;

final class UpdataStrategyEntry {
    private int defaultUpdatePolicy;
    private Boolean proivdeDefaults = null;
    private IConverter<?, ?> converter = null;
    private IObservable observable = null;
    private Integer updatePolicy = null;
    private IValidator<?> afterGetValidator = null;
    private IValidator<?> afterConvertValidator = null;
    private IValidator<?> beforeSetValidator = null;

    UpdataStrategyEntry() {
    }

    public boolean isProvideDefaults() {
        return this.proivdeDefaults == null ? false : this.proivdeDefaults;
    }

    public void setDefaultUpdatePolicy(int defaultUpdatePolicy) {
        this.defaultUpdatePolicy = defaultUpdatePolicy;
    }

    public void setProvideDefaults(boolean provideDefaults) {
        BindingBuilder.verifyNotSet(this.proivdeDefaults);
        this.proivdeDefaults = provideDefaults;
    }

    public <S, D> IConverter<S, D> getConverter() {
        return this.converter;
    }

    public void setConverter(IConverter<?, ?> converter) {
        BindingBuilder.verifyNotSet(this.converter);
        this.converter = Objects.requireNonNull(converter);
    }

    public IObservable getObservable() {
        return this.observable;
    }

    void setObservable(IObservable observable) {
        BindingBuilder.verifyNotSet(this.observable);
        this.observable = Objects.requireNonNull(observable);
    }

    public int getUpdatePolicy() {
        return this.updatePolicy == null ? this.defaultUpdatePolicy : this.updatePolicy;
    }

    public void setUpdatePolicy(int updatePolicy) {
        BindingBuilder.verifyNotSet(this.updatePolicy);
        this.updatePolicy = updatePolicy;
    }

    public <T> IValidator<T> getAfterGetValidator() {
        return this.afterGetValidator;
    }

    public void setAfterGetValidator(IValidator<?> afterGetValidator) {
        BindingBuilder.verifyNotSet(this.afterGetValidator);
        this.afterGetValidator = Objects.requireNonNull(afterGetValidator);
    }

    public <T> IValidator<T> getAfterConvertValidator() {
        return this.afterConvertValidator;
    }

    public void setAfterConvertValidator(IValidator<?> afterConvertValidator) {
        BindingBuilder.verifyNotSet(this.afterConvertValidator);
        this.afterConvertValidator = Objects.requireNonNull(afterConvertValidator);
    }

    public <T> IValidator<T> getBeforeSetValidator() {
        return this.beforeSetValidator;
    }

    public void setBeforeSetValidator(IValidator<?> beforeSetValidator) {
        BindingBuilder.verifyNotSet(this.beforeSetValidator);
        this.beforeSetValidator = Objects.requireNonNull(beforeSetValidator);
    }

    public <S, D> UpdateValueStrategy<S, D> createUpdateValueStrategy() {
        UpdateValueStrategy<Object, Object> strategy = new UpdateValueStrategy<Object, Object>(this.isProvideDefaults(), this.getUpdatePolicy());
        strategy.setConverter(this.getConverter());
        strategy.setAfterConvertValidator(this.getAfterConvertValidator());
        strategy.setAfterGetValidator(this.getAfterGetValidator());
        strategy.setBeforeSetValidator(this.getBeforeSetValidator());
        return strategy;
    }

    public <S, D> UpdateListStrategy<S, D> createUpdateListStrategy() {
        UpdateListStrategy<S, D> strategy = new UpdateListStrategy<S, D>(this.isProvideDefaults(), this.getUpdatePolicy());
        strategy.setConverter(this.getConverter());
        return strategy;
    }

    public <S, D> UpdateSetStrategy<S, D> createUpdateSetStrategy() {
        UpdateSetStrategy<S, D> strategy = new UpdateSetStrategy<S, D>(this.isProvideDefaults(), this.getUpdatePolicy());
        strategy.setConverter(this.getConverter());
        return strategy;
    }
}

