/*******************************************************************************
 * Copyright (c) 2006, 2010 Soyatec (http://www.soyatec.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Soyatec - initial API and implementation
 *******************************************************************************/
package org.eclipse.xwt.ui.workbench;

import java.io.InputStream;
import java.net.URL;

/**
 * 
 * @author yyang (yves.yang@soyatec.com)
 */
public interface IPartContentProvider {

	/**
	 * Content stream
	 * 
	 * @return
	 */
	InputStream getContent();

	/**
	 * Resource location, used to resolve relative resources
	 * 
	 * @return
	 */
	URL getBase();

	/**
	 * Resource loader
	 * 
	 * @return
	 */
	ClassLoader getClassLoader();
}
