/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TaskTagsProvider {
    private static TaskTagsProvider instance;
    private HashMap<IProject, ITaskTagsListener> projectToTaskTagListener;
    private HashMap<IProject, IPreferencesPropagatorListener[]> projectToPropagatorListeners;
    private boolean isInstalled;
    private PreferencesSupport preferencesSupport;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";

    private TaskTagsProvider() {
        this.install();
    }

    @NonNull
    public static TaskTagsProvider getInstance() {
        if (instance == null) {
            instance = new TaskTagsProvider();
        }
        return instance;
    }

    @NonNull
    public TaskTag[] getWorkspaceTaskTags() {
        String priorities = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
        String tags = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
        TaskTag[] workspaceTags = TaskTagsProvider.getTagsAndPropertiesFrom(tags, priorities);
        return workspaceTags;
    }

    public boolean isWorkspaceTagsCaseSensitive() {
        String caseSensitive = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
        return "enabled".equals(caseSensitive);
    }

    @Nullable
    public TaskTag[] getProjectTaskTags(IProject project) {
        if (project == null) {
            return null;
        }
        String priorities = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, project);
        String projectTags = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, project);
        if (projectTags == null || priorities == null) {
            return null;
        }
        TaskTag[] tags = TaskTagsProvider.getTagsAndPropertiesFrom(projectTags, priorities);
        return tags;
    }

    public boolean getProjectTagsCaseSensitive(IProject project) {
        if (project == null) {
            return this.isWorkspaceTagsCaseSensitive();
        }
        String caseSensitive = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, project);
        if (caseSensitive == null) {
            return this.isWorkspaceTagsCaseSensitive();
        }
        return "enabled".equals(caseSensitive);
    }

    public void addTaskTagsListener(ITaskTagsListener listener, IProject project) {
        if (listener == null || project == null) {
            return;
        }
        this.projectToTaskTagListener.put(project, listener);
        this.installPropagatorListeners(project);
    }

    public void removeTaskTagsListener(IProject project) {
        if (project == null) {
            return;
        }
        this.projectToTaskTagListener.remove(project);
        this.uninstallPropagatorListeners(project);
    }

    private void installPropagatorListeners(@NonNull IProject project) {
        IPreferencesPropagatorListener[] listeners = new IPreferencesPropagatorListener[]{new InnerTaskTagsListener(project), new InnerTaskPrioritiesListener(project), new InnerTaskCaseListener(project)};
        this.preferencesPropagator.addPropagatorListener(listeners[0], "org.eclipse.php.core.taskTags");
        this.preferencesPropagator.addPropagatorListener(listeners[1], "org.eclipse.php.core.taskPriorities");
        this.preferencesPropagator.addPropagatorListener(listeners[2], "org.eclipse.php.core.taskCaseSensitive");
        this.projectToPropagatorListeners.put(project, listeners);
    }

    private void uninstallPropagatorListeners(IProject project) {
        IPreferencesPropagatorListener[] listeners = this.projectToPropagatorListeners.get(project);
        if (listeners != null) {
            this.preferencesPropagator.removePropagatorListener(listeners[0], "org.eclipse.php.core.taskTags");
            this.preferencesPropagator.removePropagatorListener(listeners[1], "org.eclipse.php.core.taskPriorities");
            this.preferencesPropagator.removePropagatorListener(listeners[2], "org.eclipse.php.core.taskCaseSensitive");
        }
        this.projectToPropagatorListeners.remove(project);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER);
        this.projectToTaskTagListener = new HashMap();
        this.projectToPropagatorListeners = new HashMap();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER);
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        Set<IProject> keys = this.projectToPropagatorListeners.keySet();
        IProject[] projects = new IProject[keys.size()];
        keys.toArray(projects);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            this.uninstallPropagatorListeners(element);
            ++n2;
        }
        this.preferencesSupport = null;
        this.preferencesPropagator = null;
        this.projectToTaskTagListener = null;
        this.projectToPropagatorListeners = null;
        this.isInstalled = false;
    }

    private void notifyTaskTagChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskTagsChanged(event);
            ++n2;
        }
    }

    private void notifyTaskPriorityChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskPrioritiesChanged(event);
            ++n2;
        }
    }

    private void notifyTaskCaseChange(TaskTagsEvent event) {
        ITaskTagsListener[] allListeners = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(allListeners);
        ITaskTagsListener[] iTaskTagsListenerArray = allListeners;
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskTagsListener element = iTaskTagsListenerArray[n2];
            element.taskCaseChanged(event);
            ++n2;
        }
    }

    @NonNull
    private static TaskTag[] getTagsAndPropertiesFrom(String tagString, String priorityString) {
        String[] tags = StringUtils.unpack((String)tagString);
        String[] priorities = StringUtils.unpack((String)priorityString);
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] stringArray = priorities;
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Integer number = null;
            number = "HIGH".equals(element) ? Integer.valueOf(2) : ("LOW".equals(element) ? Integer.valueOf(0) : Integer.valueOf(1));
            list.add(number);
            ++n2;
        }
        Integer[] allPriorities = new Integer[list.size()];
        list.toArray(allPriorities);
        TaskTag[] taskTags = new TaskTag[Math.min(tags.length, priorities.length)];
        int i = 0;
        while (i < taskTags.length) {
            taskTags[i] = new TaskTag(tags[i], allPriorities[i].intValue());
            ++i;
        }
        return taskTags;
    }

    private abstract class AbstractTasksListener
    implements IPreferencesPropagatorListener {
        @NonNull
        private IProject project;

        public AbstractTasksListener(IProject project) {
            this.project = project;
        }

        @Override
        @NonNull
        public IProject getProject() {
            return this.project;
        }
    }

    private class InnerTaskCaseListener
    extends AbstractTasksListener {
        public InnerTaskCaseListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject());
            String priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, this.getProject());
            String caseSensitive = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, this.getProject());
            String newValue = (String)event.getNewValue();
            if (tags == null || priorities == null || caseSensitive == null || newValue == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
                newValue = caseSensitive = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
            }
            if (StringUtils.occurrencesOf((String)tags, (char)',') == StringUtils.occurrencesOf((String)priorities, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.getTagsAndPropertiesFrom(tags, priorities);
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, "enabled".equals(newValue));
                TaskTagsProvider.this.notifyTaskCaseChange(taskEvent);
            }
        }
    }

    private class InnerTaskPrioritiesListener
    extends AbstractTasksListener {
        public InnerTaskPrioritiesListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject());
            String priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, this.getProject());
            String caseSensitive = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, this.getProject());
            String newValue = (String)event.getNewValue();
            if (tags == null || priorities == null || caseSensitive == null || newValue == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
                caseSensitive = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
                newValue = priorities;
            }
            if (StringUtils.occurrencesOf((String)tags, (char)',') == StringUtils.occurrencesOf((String)newValue, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.getTagsAndPropertiesFrom(tags, newValue);
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, "enabled".equals(caseSensitive));
                TaskTagsProvider.this.notifyTaskPriorityChange(taskEvent);
            }
        }
    }

    private class InnerTaskTagsListener
    extends AbstractTasksListener {
        public InnerTaskTagsListener(IProject project) {
            super(project);
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String tags = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject());
            String priorities = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, this.getProject());
            String caseSensitive = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, this.getProject());
            String newValue = (String)event.getNewValue();
            if (tags == null || priorities == null || caseSensitive == null || newValue == null) {
                tags = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
                priorities = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
                caseSensitive = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
                newValue = tags;
            }
            if (StringUtils.occurrencesOf((String)newValue, (char)',') == StringUtils.occurrencesOf((String)priorities, (char)',')) {
                TaskTag[] taskTags = TaskTagsProvider.getTagsAndPropertiesFrom(newValue, priorities);
                TaskTagsEvent taskEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTags, "enabled".equals(caseSensitive));
                TaskTagsProvider.this.notifyTaskTagChange(taskEvent);
            }
        }
    }
}

