/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.MaxCellBoundsHelper;
import org.eclipse.nebula.widgets.nattable.resize.command.AutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiColumnResizeCommand;

public class AutoResizeColumnCommandHandler
implements ILayerCommandHandler<AutoResizeColumnsCommand> {
    protected final ILayer commandLayer;
    protected final ILayer positionLayer;

    public AutoResizeColumnCommandHandler(ILayer commandLayer, ILayer positionLayer) {
        this.commandLayer = commandLayer;
        this.positionLayer = positionLayer;
    }

    public AutoResizeColumnCommandHandler(GridLayer gridLayer) {
        this.commandLayer = gridLayer;
        this.positionLayer = gridLayer.getBodyLayer();
    }

    @Override
    public Class<AutoResizeColumnsCommand> getCommandClass() {
        return AutoResizeColumnsCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, AutoResizeColumnsCommand command) {
        targetLayer.doCommand(new TurnViewportOffCommand());
        int[] columnPositions = command.getColumnPositionsArray();
        int[] gridColumnPositions = command.doPositionTransformation() ? this.convertFromPositionToCommandLayer(columnPositions) : columnPositions;
        int[] gridColumnWidths = MaxCellBoundsHelper.getPreferredColumnWidths(command.getConfigRegistry(), command.getGCFactory(), this.commandLayer, gridColumnPositions);
        if (gridColumnWidths != null && gridColumnWidths.length > 0) {
            this.commandLayer.doCommand(new MultiColumnResizeCommand(this.commandLayer, gridColumnPositions, gridColumnWidths, true));
        }
        targetLayer.doCommand(new TurnViewportOnCommand());
        return true;
    }

    protected int[] convertFromPositionToCommandLayer(int[] columnPositions) {
        int[] commandLayerColumnPositions = new int[columnPositions.length];
        int i = 0;
        while (i < columnPositions.length) {
            commandLayerColumnPositions[i] = this.commandLayer.underlyingToLocalColumnPosition(this.positionLayer, columnPositions[i]);
            ++i;
        }
        return commandLayerColumnPositions;
    }
}

