/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExecutableXMIHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.util.TypeUtil;

public class ElementOperations
extends AbstractContextualOperations {
    static final String CONTAINER_NAME = "container";
    static final String DEEP_CLONE_NAME = "deepclone";
    static final String CLONE_NAME = "clone";
    static final String METACLASS_NAME = "metaClassName";
    static final String SUBOBJECTS_NAME = "subobjects";
    static final String ALL_SUBOBJECTS_NAME = "allSubobjects";
    static final String SUBOBJECTS_OF_KIND_NAME = "subobjectsOfKind";
    static final String ALL_SUBOBJECTS_OF_KIND_NAME = "allSubobjectsOfKind";
    static final String SUBOBJECTS_OF_TYPE_NAME = "subobjectsOfType";
    static final String ALL_SUBOBJECTS_OF_TYPE_NAME = "allSubobjectsOfType";
    static final int FILTER_ALL = 0;
    static final int FILTER_OF_TYPE = 1;
    static final int FILTER_OF_KIND = 2;
    private static final CallHandler DEEP_CLONE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                IntermediatePropertyCopier copier = new IntermediatePropertyCopier(evalEnv);
                ExecutableXMIHelper.fixEObjectOnSave(eObject);
                EObject result = copier.copy(eObject);
                copier.copyReferences();
                ExecutableXMIHelper.fixEObjectOnLoad(result);
                ModelParameterExtent extent = evalEnv.getDefaultInstantiationExtent((EClassifier)eObject.eClass());
                if (extent != null) {
                    extent.addObject(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler CLONE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                IntermediatePropertyCopier copier = new IntermediatePropertyCopier(evalEnv){

                    protected void copyContainment(EReference arg0, EObject arg1, EObject arg2) {
                    }
                };
                EObject result = copier.copy(eObject);
                copier.copyReferences();
                ModelParameterExtent extent = evalEnv.getDefaultInstantiationExtent((EClassifier)eObject.eClass());
                if (extent != null) {
                    TreeIterator contentIter = EcoreUtil.getAllProperContents((EObject)result, (boolean)false);
                    while (contentIter.hasNext()) {
                        extent.addObject((EObject)contentIter.next());
                    }
                    extent.addObject(result);
                }
                return result;
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler CONTAINER = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return eObject.eContainer();
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler METACLASS = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return eObject.eClass().getName();
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler SUBOBJECTS = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, null, 0, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler SUBOBJECTS_OF_TYPE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, ElementOperations.getTypeFilterArg(args), 1, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler SUBOBJECTS_OF_KIND = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getSubObjects(eObject, ElementOperations.getTypeFilterArg(args), 2, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler ALL_SUBOBJECTS = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                return ElementOperations.getAllSubObjects(eObject, null, 0, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    private static final CallHandler ALL_SUBOBJECTS_OF_TYPE = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EClassifier type = ElementOperations.getTypeFilterArg(args);
                return ElementOperations.getAllSubObjects(eObject, type, 1, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };
    static final CallHandler ALL_SUBOBJECTS_OF_KIND = new CallHandler(){

        @Override
        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            if (source instanceof EObject) {
                EObject eObject = (EObject)source;
                EClassifier type = ElementOperations.getTypeFilterArg(args);
                return ElementOperations.getAllSubObjects(eObject, type, 2, evalEnv);
            }
            return CallHandlerAdapter.getInvalidResult(evalEnv);
        }
    };

    public ElementOperations(AbstractQVTStdlib library) {
        super(library, library.getElementType());
    }

    @Override
    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary<EClassifier> oclStdlib = this.getStdlib().getOCLStdLib();
        EClassifier setOfElement = (EClassifier)TypeUtil.resolveSetType((Environment)this.getStdlib().getEnvironment(), (Object)this.getStdlib().getElementType());
        return new AbstractContextualOperations.OwnedOperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "_localId", (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "_globalId", (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS, ALL_SUBOBJECTS_NAME, setOfElement, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS_OF_TYPE, ALL_SUBOBJECTS_OF_TYPE_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(ALL_SUBOBJECTS_OF_KIND, ALL_SUBOBJECTS_OF_KIND_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(CLONE, CLONE_NAME, (EClassifier)oclStdlib.getT(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(CONTAINER, CONTAINER_NAME, this.getStdlib().getElementType(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(DEEP_CLONE, DEEP_CLONE_NAME, (EClassifier)oclStdlib.getT(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "markedAs", new String[]{"value"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "markValue", this.getStdlib().getObject(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(METACLASS, METACLASS_NAME, (EClassifier)oclStdlib.getString(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "stereotypedBy", new String[]{"value"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, "stereotypedStrictBy", new String[]{"value"}, (EClassifier)oclStdlib.getBoolean(), (EClassifier)oclStdlib.getString()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS, SUBOBJECTS_NAME, setOfElement, new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS_OF_TYPE, SUBOBJECTS_OF_TYPE_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType()), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(SUBOBJECTS_OF_KIND, SUBOBJECTS_OF_KIND_NAME, new String[]{"type"}, (EClassifier)oclStdlib.getSet(), (EClassifier)oclStdlib.getOclType())};
    }

    static EClassifier getTypeFilterArg(Object[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        Object typeObj = args[0];
        if (!(typeObj instanceof EClassifier)) {
            throw new IllegalArgumentException();
        }
        return (EClassifier)typeObj;
    }

    private static Object getAllSubObjects(EObject eObject, EClassifier type, int filterFlag, QvtOperationalEvaluationEnv evalEnv) {
        HashSet<EObject> result = new HashSet<EObject>();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iter.hasNext()) {
            boolean accept;
            EObject subObject = (EObject)iter.next();
            boolean bl = accept = filterFlag == 0;
            if (2 == filterFlag) {
                accept = evalEnv.isKindOf(subObject, type);
            } else if (1 == filterFlag) {
                accept = evalEnv.isTypeOf(subObject, type);
            }
            if (!accept) continue;
            result.add(subObject);
        }
        return result;
    }

    private static Object getSubObjects(EObject eObject, EClassifier type, int filterFlag, QvtOperationalEvaluationEnv evalEnv) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject subObject : eObject.eContents()) {
            boolean accept;
            boolean bl = accept = filterFlag == 0;
            if (2 == filterFlag) {
                accept = evalEnv.isKindOf(subObject, type);
            } else if (1 == filterFlag) {
                accept = evalEnv.isTypeOf(subObject, type);
            }
            if (!accept) continue;
            result.add(subObject);
        }
        return result;
    }

    private static class IntermediatePropertyCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 1L;
        private final QvtOperationalEvaluationEnv evalEnv;
        private final Map<Object, Object> qvtoObjectMap;

        public IntermediatePropertyCopier(QvtOperationalEvaluationEnv evalEnv) {
            this.evalEnv = evalEnv;
            this.qvtoObjectMap = new IdentityHashMap<Object, Object>();
        }

        public void copyReferences() {
            super.copyReferences();
            Module rootModule = this.evalEnv.getRoot().getAdapter(InternalEvaluationEnv.class).getCurrentModule().getModule();
            for (Map.Entry entry : this.entrySet()) {
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                this.cloneIntermediateProperties(eObject, copyEObject, rootModule);
            }
        }

        private void cloneIntermediateProperties(EObject source, EObject target, Module module) {
            for (EStructuralFeature feature : module.getEAllStructuralFeatures()) {
                ContextualProperty property;
                if (!(feature instanceof ContextualProperty) || !(property = (ContextualProperty)feature).getContext().isSuperTypeOf(source.eClass())) continue;
                Object value = this.evalEnv.navigateProperty(property, null, source);
                Object result = this.get(value);
                if (result == null && (property.getEType() instanceof CollectionType && value instanceof Collection || property.getEType() instanceof org.eclipse.ocl.ecore.TupleType && value instanceof Tuple)) {
                    result = this.cloneOclObjects(value);
                }
                if (this.useOriginalReferences && result == null) {
                    result = value;
                }
                this.evalEnv.callSetter(target, property, result, QvtOperationalUtil.isUndefined(result, this.evalEnv), true);
            }
            for (ModuleImport moduleImport : module.getModuleImport()) {
                Module importedModule = moduleImport.getImportedModule();
                this.cloneIntermediateProperties(source, target, importedModule);
            }
        }

        private Object cloneOclObjects(Object value) {
            if (value instanceof Dictionary) {
                Dictionary result = this.qvtoObjectMap.get(value);
                if (result == null) {
                    result = this.cloneDictionary((Dictionary)value);
                    this.qvtoObjectMap.put(value, result);
                }
                return result;
            }
            if (value instanceof Collection) {
                Collection result = this.qvtoObjectMap.get(value);
                if (result == null) {
                    result = this.cloneCollection((Collection)value);
                    this.qvtoObjectMap.put(value, result);
                }
                return result;
            }
            if (value instanceof Tuple) {
                Tuple result = this.qvtoObjectMap.get(value);
                if (result == null) {
                    result = this.cloneTuple((Tuple)value);
                    this.qvtoObjectMap.put(value, result);
                }
                return result;
            }
            Object result = this.get(value);
            if (this.useOriginalReferences && result == null) {
                result = value;
            }
            return result;
        }

        private <T> Collection<T> cloneCollection(Collection<T> collection) {
            Collection<T> resultCollection = EvaluationUtil.createNewCollectionOfSameKind(collection);
            for (T object : collection) {
                resultCollection.add(this.cloneOclObjects(object));
            }
            return resultCollection;
        }

        private <T1, T2> Dictionary<T1, T2> cloneDictionary(Dictionary<T1, T2> dictionary) {
            Dictionary resultDict = (Dictionary)EvaluationUtil.createNewCollectionOfSameKind(dictionary);
            for (T1 key : dictionary.keys()) {
                T2 value = dictionary.get(key);
                resultDict.put(this.cloneOclObjects(key), this.cloneOclObjects(value));
            }
            return resultDict;
        }

        private <T1, T2> Tuple<T1, T2> cloneTuple(Tuple<T1, T2> value) {
            HashMap propertyValues = new HashMap();
            TupleType tupleType = value.getTupleType();
            for (Object part : tupleType.oclProperties()) {
                propertyValues.put(part, this.cloneOclObjects(value.getValue(part)));
            }
            return this.evalEnv.createTuple((EClassifier)tupleType, propertyValues);
        }
    }
}

