/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.lm.reviews.ModelReference;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.net4j.util.om.OMPlatform;

public class CompareModelReferenceExtractor
implements ModelReference.Extractor {
    public static final int PRIORITY = 1000;
    private static final int ATTRIBUTE_VALUE_MAX_LENGTH = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.lm.reviews.ui.CompareModelReferenceExtractor.ATTRIBUTE_VALUE_MAX_LENGTH", -1);
    private final int attributeValueMaxLength;

    public CompareModelReferenceExtractor(int attributeValueMaxLength) {
        this.attributeValueMaxLength = attributeValueMaxLength;
    }

    public CompareModelReferenceExtractor() {
        this(ATTRIBUTE_VALUE_MAX_LENGTH);
    }

    public int getPriority() {
        return 1000;
    }

    public ModelReference extractModelReference(Object object) {
        TreeNode treeNode = CDOCompareEditorUtil.Input.getTreeNode((Object)object);
        if (treeNode == null) {
            return null;
        }
        EObject data = treeNode.getData();
        if (data instanceof Match) {
            Match match = (Match)data;
            return CompareModelReferenceExtractor.addMatch(ModelReference.builder((String)"match"), match).build();
        }
        if (data instanceof AttributeChange) {
            AttributeChange diff = (AttributeChange)data;
            return CompareModelReferenceExtractor.addDiff((Diff)diff, (EStructuralFeature)diff.getAttribute()).property(diff.getValue(), this.attributeValueMaxLength).build();
        }
        if (data instanceof ReferenceChange) {
            ReferenceChange diff = (ReferenceChange)data;
            return CompareModelReferenceExtractor.addDiff((Diff)diff, (EStructuralFeature)diff.getReference()).property(diff.getValue()).build();
        }
        return null;
    }

    private static ModelReference.Builder addDiff(Diff diff, EStructuralFeature feature) {
        DifferenceKind kind = diff.getKind();
        String type = kind == null ? "diff" : kind.getName().toLowerCase();
        Match match = diff.getMatch();
        String featureName = feature.getName();
        return CompareModelReferenceExtractor.addMatch(ModelReference.builder((String)type), match).property((Object)featureName);
    }

    private static ModelReference.Builder addMatch(ModelReference.Builder builder, Match match) {
        EObject matchObject = CompareModelReferenceExtractor.getMatchObject(match);
        CDOID objectID = CDOIDUtil.getCDOID((Object)matchObject);
        return builder.property(objectID);
    }

    private static EObject getMatchObject(Match match) {
        EObject left = match.getLeft();
        if (left != null) {
            return left;
        }
        EObject right = match.getRight();
        if (right != null) {
            return right;
        }
        return match.getOrigin();
    }
}

