/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.workspace;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfig;
import org.eclipse.xtext.ui.workspace.EclipseProjectConfigProvider;
import org.eclipse.xtext.ui.workspace.EclipseSourceFolder;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JdtProjectConfig
extends EclipseProjectConfig {
    public JdtProjectConfig(IProject project, EclipseProjectConfigProvider projectConfigProvider) {
        super(project, projectConfigProvider);
    }

    @Override
    public Set<? extends ISourceFolder> getSourceFolders() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        if (!javaProject.exists()) {
            return Collections.emptySet();
        }
        try {
            return Arrays.stream(javaProject.getRawClasspath()).filter(entry -> entry.getEntryKind() == 3).map(entry -> entry.getPath().removeFirstSegments(1).toString()).map(entryName -> new EclipseSourceFolder(this.getProject(), (String)entryName)).collect(Collectors.toSet());
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).addAllFields().toString();
    }
}

