/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.viatra.query.patternlanguage.emf.ui.builder.configuration.EMFPatternLanguageBuilderPreferenceAccess;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class EnsurePluginSupport {
    @Inject
    private Logger logger;
    @Inject
    private EMFPatternLanguageBuilderPreferenceAccess builderPreferenceAccess;
    private Multimap<IProject, String> exportedPackageMap = HashMultimap.create();
    private Multimap<IProject, ExtensionData> appendableExtensionMap = ArrayListMultimap.create();
    private Multimap<IProject, Pair<String, String>> removableExtensionMap = ArrayListMultimap.create();
    private Multimap<IProject, String> modelBundleIds = HashMultimap.create();

    public void appendExtension(IProject project, ExtensionData extension) {
        this.appendableExtensionMap.put((Object)project, (Object)extension);
    }

    public void appendAllExtension(IProject project, Iterable<ExtensionData> extensions) {
        this.appendableExtensionMap.putAll((Object)project, extensions);
    }

    public void removeExtension(IProject project, Pair<String, String> extension) {
        this.removableExtensionMap.put((Object)project, extension);
    }

    public void removeAllExtension(IProject targetProject, Iterable<Pair<String, String>> extensions) {
        this.removableExtensionMap.putAll((Object)targetProject, extensions);
    }

    public void exportPackage(IProject project, String packageName) {
        this.exportedPackageMap.put((Object)project, (Object)packageName);
    }

    public void addModelBundleId(IProject project, String bundleId) {
        this.modelBundleIds.put((Object)project, (Object)bundleId);
    }

    public void clean() {
        this.exportedPackageMap.clear();
        this.appendableExtensionMap.clear();
        this.removableExtensionMap.clear();
        this.modelBundleIds.clear();
    }

    public void ensure(IProject modelProject, IProgressMonitor monitor) {
        block6: {
            try {
                try {
                    if (ProjectGenerationHelper.isOpenPDEProject((IProject)modelProject)) {
                        this.internalEnsure(modelProject, monitor);
                        break block6;
                    }
                    this.logger.info((Object)String.format("Project %s is not a plug-in project, metadata has to be managed manually.", modelProject.getName()));
                }
                catch (Exception e) {
                    this.logger.error((Object)"Exception during Extension/Package ensure Phase", (Throwable)e);
                    monitor.worked(1);
                }
            }
            finally {
                monitor.worked(1);
            }
        }
    }

    public Collection<String> getModelBundleDependencies(IProject project) {
        return this.modelBundleIds.get((Object)project);
    }

    private void internalEnsure(IProject modelProject, IProgressMonitor monitor) throws CoreException {
        if (this.builderPreferenceAccess.isManifestGenerationEnabled(modelProject)) {
            this.ensurePackages(monitor);
        }
        if (this.builderPreferenceAccess.isExtensionGenerationEnabled(modelProject)) {
            this.ensureExtensions(monitor);
        }
    }

    private void ensurePackages(IProgressMonitor monitor) throws CoreException {
        for (IProject proj : this.exportedPackageMap.keySet()) {
            ProjectGenerationHelper.ensurePackageExports((IProject)proj, (Collection)this.exportedPackageMap.get((Object)proj));
        }
    }

    private void ensureExtensions(IProgressMonitor monitor) throws CoreException {
        if (!this.appendableExtensionMap.isEmpty()) {
            for (IProject proj : this.appendableExtensionMap.keySet()) {
                Collection extensions = this.appendableExtensionMap.get((Object)proj);
                Collection removableExtensions = this.removableExtensionMap.get((Object)proj);
                if (!removableExtensions.isEmpty()) {
                    this.removeSameExtensions(removableExtensions, extensions);
                }
                ProjectGenerationHelper.ensureExtensions((IProject)proj, (Iterable)extensions, (Iterable)removableExtensions);
            }
            for (IProject proj : this.removableExtensionMap.keySet()) {
                if (this.appendableExtensionMap.containsKey((Object)proj)) continue;
                Collection removableExtensions = this.removableExtensionMap.get((Object)proj);
                ArrayList extensions = Lists.newArrayList();
                ProjectGenerationHelper.ensureExtensions((IProject)proj, (Iterable)extensions, (Iterable)removableExtensions);
            }
        } else {
            for (IProject proj : this.removableExtensionMap.keySet()) {
                Collection removableExtensions = this.removableExtensionMap.get((Object)proj);
                ArrayList extensions = Lists.newArrayList();
                ProjectGenerationHelper.ensureExtensions((IProject)proj, (Iterable)extensions, (Iterable)removableExtensions);
            }
        }
    }

    private void removeSameExtensions(Collection<Pair<String, String>> removeFrom, Iterable<ExtensionData> searchList) {
        for (ExtensionData ext : searchList) {
            removeFrom.removeIf(p -> Objects.equals(p.getKey(), ext.getId()) && Objects.equals(p.getValue(), ext.getPoint()));
        }
    }
}

