/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.description.CompositeLayout;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.LayoutDirection;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.CompoundLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.DiagramLayoutCustomization;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeSelectionLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.BorderItemAwareLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.CompositeLeftRightLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.PinnedElementsLayoutProvider;

public class CompositeLeftRightProvider
implements LayoutProvider {
    private AbstractLayoutEditPartProvider layoutNodeProvider;

    @Override
    public AbstractLayoutEditPartProvider getLayoutNodeProvider(IGraphicalEditPart container) {
        if (this.layoutNodeProvider == null) {
            CompoundLayoutProvider clp = new CompoundLayoutProvider();
            CompositeLeftRightLayoutProvider cdtp = new CompositeLeftRightLayoutProvider();
            clp.addProvider((AbstractLayoutEditPartProvider)cdtp);
            clp.addProvider(new PinnedElementsLayoutProvider(cdtp));
            BorderItemAwareLayoutProvider abstractLayoutProvider = new BorderItemAwareLayoutProvider(clp, true);
            this.layoutNodeProvider = new ArrangeSelectionLayoutProvider(abstractLayoutProvider);
        }
        return this.layoutNodeProvider;
    }

    @Override
    public boolean provides(IGraphicalEditPart container) {
        return this.isInDDiagramWithConfiguredLeftRightLayout(container.getNotationView());
    }

    private boolean isInDDiagramWithConfiguredLeftRightLayout(View view) {
        Layout foundLayout = DiagramLayoutCustomization.findLayoutSettings(view);
        if (foundLayout instanceof CompositeLayout) {
            return ((CompositeLayout)foundLayout).getDirection() == LayoutDirection.LEFT_TO_RIGHT;
        }
        return false;
    }

    @Override
    public boolean isDiagramLayoutProvider() {
        return true;
    }
}

