/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.filesystem.ui;

import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.filesystem.Policy;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemOperation;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.ui.IWorkbenchPart;

public class GetOperation
extends FileSystemOperation {
    private boolean overwriteOutgoing;

    public GetOperation(IWorkbenchPart part, SubscriberScopeManager manager) {
        super(part, manager);
    }

    protected void execute(FileSystemProvider provider, ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        try {
            provider.getOperations().get(traversals, this.isOverwriteOutgoing(), monitor);
            if (!this.isOverwriteOutgoing() && this.hasIncomingChanges(traversals)) {
                throw new TeamException("Could not get all changes due to conflicts.");
            }
            provider.getProject().refreshLocal(2, monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasIncomingChanges(ResourceTraversal[] traversals) throws CoreException {
        final RuntimeException found = new RuntimeException();
        try {
            FileSystemSubscriber.getInstance().accept(traversals, new IDiffVisitor(){

                public boolean visit(IDiff diff) {
                    IThreeWayDiff twd;
                    if (diff instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)diff).getDirection() == 512 || twd.getDirection() == 768)) {
                        throw found;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            if (e == found) {
                return true;
            }
            throw e;
        }
        return false;
    }

    protected boolean isOverwriteOutgoing() {
        return this.overwriteOutgoing;
    }

    public void setOverwriteOutgoing(boolean overwriteOutgoing) {
        this.overwriteOutgoing = overwriteOutgoing;
    }

    protected String getTaskName() {
        return Policy.bind("GetAction.working");
    }
}

