/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;

public class DLTKLaunchableTester
extends PropertyTester {
    private static final String PROPERTY_IS_CONTAINER = "isContainer";
    private static final String PROPERTY_PROJECT_NATURE = "hasProjectNature";
    private static final String PROPERTY_BUILDPATH_REFERENCE = "buildpathReference";

    private boolean hasProjectNature(IModelElement element, String ntype) {
        try {
            IResource resource;
            if (element != null && (resource = element.getResource()) != null) {
                IProject proj = resource.getProject();
                return proj.isAccessible() && proj.hasNature(ntype);
            }
            return false;
        }
        catch (CoreException e) {
            return false;
        }
    }

    private boolean hasItemOnBuildPath(IModelElement element, Object[] args) {
        if (element != null && args != null) {
            IScriptProject project = element.getScriptProject();
            HashSet<IScriptProject> searched = new HashSet<IScriptProject>();
            searched.add(project);
            return this.hasItemsOnBuildPath(project, searched, args);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasItemsOnBuildPath(IScriptProject project, Set<IScriptProject> searched, Object[] args) {
        try {
            ArrayList<IScriptProject> projects = new ArrayList<IScriptProject>();
            if (project != null && project.exists()) {
                IBuildpathEntry[] entries = project.getResolvedBuildpath(true);
                int i = 0;
                while (i < entries.length) {
                    IBuildpathEntry entry = entries[i];
                    IPath path = entry.getPath();
                    String spath = path.toPortableString();
                    int j = 0;
                    while (j < args.length) {
                        if (spath.lastIndexOf((String)args[j]) != -1) {
                            return true;
                        }
                        ++j;
                    }
                    if (entry.getEntryKind() == 2) {
                        String name = entry.getPath().lastSegment();
                        IProject dep = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        IScriptProject scriptProject = DLTKCore.create((IProject)dep);
                        if (!searched.contains(scriptProject)) {
                            projects.add(scriptProject);
                        }
                    }
                    ++i;
                }
            }
            for (IScriptProject jp : projects) {
                searched.add(jp);
                if (!this.hasItemsOnBuildPath(jp, searched, args)) continue;
                return true;
            }
            return false;
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return false;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IS_CONTAINER.equals(property)) {
            IResource resource;
            if (receiver instanceof IAdaptable && (resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null) {
                return resource instanceof IContainer;
            }
            return false;
        }
        IModelElement element = null;
        if (receiver instanceof IAdaptable) {
            IResource res;
            element = (IModelElement)((IAdaptable)receiver).getAdapter(IModelElement.class);
            if (element == null && (res = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null) {
                element = DLTKCore.create((IResource)res);
            }
            if (element != null && !element.exists()) {
                return false;
            }
        }
        if (PROPERTY_BUILDPATH_REFERENCE.equals(property)) {
            return this.hasItemOnBuildPath(element, args);
        }
        if (PROPERTY_PROJECT_NATURE.equals(property) && args.length > 0 && args[0] != null) {
            return this.hasProjectNature(element, (String)args[0]);
        }
        return false;
    }
}

