/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 
 *******************************************************************************/
package org.eclipse.dltk.internal.core;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;

class SourceRefElementInfo extends ModelElementInfo {
	protected int fSourceRangeStart, fSourceRangeEnd;

	public int getDeclarationSourceEnd() {
		return fSourceRangeEnd;
	}

	public int getDeclarationSourceStart() {
		return fSourceRangeStart;
	}
	
	protected ISourceRange getSourceRange() {
		return new SourceRange(fSourceRangeStart, fSourceRangeEnd - fSourceRangeStart + 1);
	}
	
	protected void setSourceRangeEnd(int end) {
		fSourceRangeEnd = end;
	}
	
	protected void setSourceRangeStart(int start) {
		fSourceRangeStart = start;
	}

}
