/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class WorkOfflineAction
extends BaseSelectionListenerAction
implements IObjectActionDelegate,
IActionDelegate2 {
    private ISelectionProvider mSelectionProvider;

    public WorkOfflineAction() {
        super(ConnectivityUIPlugin.getDefault().getResourceString("DATATOOLS.SERVER.UI.EXPLORER.WORKOFFLINE"));
        this.setToolTipText(this.getText());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setSelectionProvider(targetPart.getSite().getSelectionProvider());
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.mSelectionProvider != null) {
            this.mSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.mSelectionProvider = selectionProvider;
        if (this.mSelectionProvider != null) {
            this.mSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            ISelection selection = this.mSelectionProvider.getSelection();
            this.selectionChanged((IStructuredSelection)(selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY));
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        Iterator it = this.getStructuredSelection().iterator();
        while (it.hasNext()) {
            ((IConnectionProfile)it.next()).workOffline(null);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = !selection.isEmpty();
        Iterator it = selection.iterator();
        while (enabled && it.hasNext()) {
            Object obj = it.next();
            boolean bl = enabled = obj instanceof IConnectionProfile && ((IConnectionProfile)obj).getConnectionState() != 2 && ((IConnectionProfile)obj).canWorkOffline();
        }
        return enabled && super.updateSelection(selection);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    public void dispose() {
        if (this.mSelectionProvider != null) {
            this.mSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.mSelectionProvider = null;
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }
}

