/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.visualizer.core.Extension;
import org.eclipse.cdt.visualizer.ui.IVisualizer;
import org.eclipse.cdt.visualizer.ui.IVisualizerViewer;
import org.eclipse.cdt.visualizer.ui.VisualizerView;
import org.eclipse.cdt.visualizer.ui.events.IVisualizerViewerListener;
import org.eclipse.cdt.visualizer.ui.events.VisualizerViewerEvent;
import org.eclipse.cdt.visualizer.ui.plugin.CDTVisualizerUIPlugin;
import org.eclipse.cdt.visualizer.ui.util.ListenerList;
import org.eclipse.cdt.visualizer.ui.util.SelectionManager;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.PageBook;

public class VisualizerViewer
extends PageBook
implements IVisualizerViewer,
MenuDetectListener,
ISelectionProvider,
ISelectionChangedListener {
    public static final String VISUALIZER_EXTENSION_POINT_NAME = "visualizer";
    protected VisualizerView m_view = null;
    protected Composite m_parent = null;
    protected Map<String, IVisualizer> m_visualizers = null;
    protected IVisualizer m_currentVisualizer = null;
    protected ListenerList m_listeners = null;
    protected SelectionManager m_selectionManager = null;

    public VisualizerViewer(VisualizerView view, Composite parent) {
        super(parent, 0);
        this.initVisualizerViewer(view, parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VisualizerViewer.this.dispose();
            }
        });
    }

    public void dispose() {
        this.cleanupVisualizerViewer();
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void initVisualizerViewer(VisualizerView view, Composite parent) {
        this.m_view = view;
        this.m_parent = parent;
        this.m_listeners = new ListenerList(this, "VisualizerViewer event listeners"){

            @Override
            public void raise(Object listener, Object event) {
                if (listener instanceof IVisualizerViewerListener && event instanceof VisualizerViewerEvent) {
                    IVisualizerViewerListener typedListener = (IVisualizerViewerListener)listener;
                    VisualizerViewerEvent typedEvent = (VisualizerViewerEvent)event;
                    typedListener.visualizerEvent(VisualizerViewer.this, typedEvent);
                }
            }
        };
        this.m_selectionManager = new SelectionManager(this, "Visualizer Viewer selection manager");
        Display display = this.getDisplay();
        this.setBackground(display.getSystemColor(22));
        this.setForeground(display.getSystemColor(21));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                VisualizerViewer.this.paint(e.gc);
            }
        });
        this.loadVisualizers();
    }

    protected void cleanupVisualizerViewer() {
        this.disposeVisualizers();
        if (this.m_selectionManager != null) {
            this.m_selectionManager.dispose();
            this.m_selectionManager = null;
        }
    }

    @Override
    public VisualizerView getView() {
        return this.m_view;
    }

    @Override
    public String getVisualizerName() {
        String result = VISUALIZER_EXTENSION_POINT_NAME;
        if (this.m_currentVisualizer != null) {
            result = this.m_currentVisualizer.getName();
        }
        return result;
    }

    @Override
    public String getVisualizerDisplayName() {
        String result = "Visualizer";
        if (this.m_currentVisualizer != null) {
            result = this.m_currentVisualizer.getDisplayName();
        }
        return result;
    }

    @Override
    public String getVisualizerDescription() {
        String result = "Visualizer";
        if (this.m_currentVisualizer != null) {
            result = this.m_currentVisualizer.getDescription();
        }
        return result;
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public boolean setFocus() {
        boolean result = false;
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.getControl().setFocus();
        } else {
            result = super.setFocus();
        }
        return result;
    }

    @Override
    public void addVisualizerViewerListener(IVisualizerViewerListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public void removeVisualizerViewerListener(IVisualizerViewerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void raiseVisualizerChangedEvent() {
        VisualizerViewerEvent event = new VisualizerViewerEvent(this, 1);
        this.m_listeners.raise(event);
    }

    public void raiseContextMenuEvent(int x, int y) {
        VisualizerViewerEvent event = new VisualizerViewerEvent(this, 2, x, y);
        this.m_listeners.raise(event);
    }

    protected void loadVisualizers() {
        this.m_visualizers = new Hashtable<String, IVisualizer>();
        List visualizers = Extension.getExtensions((String)"org.eclipse.cdt.visualizer.ui", (String)VISUALIZER_EXTENSION_POINT_NAME);
        if (visualizers != null) {
            for (Extension e : visualizers) {
                String id = e.getAttribute("id");
                IVisualizer visualizerInstance = (IVisualizer)e.getClassAttribute();
                if (id == null || visualizerInstance == null) continue;
                visualizerInstance.setViewer(this);
                visualizerInstance.initializeVisualizer();
                visualizerInstance.createControl((Composite)this);
                this.m_visualizers.put(id, visualizerInstance);
            }
        }
        this.selectDefaultVisualizer();
    }

    protected void disposeVisualizers() {
        for (String id : this.m_visualizers.keySet()) {
            IVisualizer v = this.m_visualizers.get(id);
            Control c = v.getControl();
            c.dispose();
            v.disposeVisualizer();
        }
        this.m_visualizers.clear();
    }

    public void selectDefaultVisualizer() {
        this.updateVisualizerFromWorkbenchSelection();
    }

    public void selectVisualizer(IVisualizer visualizer) {
        if (visualizer == null) {
            return;
        }
        if (visualizer == this.m_currentVisualizer) {
            return;
        }
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.visualizerDeselected();
            this.m_currentVisualizer.getControl().removeMenuDetectListener((MenuDetectListener)this);
            this.m_currentVisualizer.removeSelectionChangedListener(this);
        }
        this.m_currentVisualizer = visualizer;
        if (this.m_currentVisualizer != null) {
            this.showPage(visualizer.getControl());
            this.m_currentVisualizer.getControl().addMenuDetectListener((MenuDetectListener)this);
            this.m_currentVisualizer.addSelectionChangedListener(this);
            this.raiseVisualizerChangedEvent();
            this.updateWorkbenchFromVisualizerSelection();
            this.m_currentVisualizer.visualizerSelected();
        }
    }

    public IVisualizer getVisualizer() {
        return this.m_currentVisualizer;
    }

    @Override
    public void populateToolBar(IToolBarManager toolBarManager) {
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.populateToolBar(toolBarManager);
        }
    }

    @Override
    public void populateMenu(IMenuManager menuManager) {
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.populateMenu(menuManager);
        }
    }

    public void menuDetected(MenuDetectEvent e) {
        this.raiseContextMenuEvent(e.x, e.y);
    }

    @Override
    public void populateContextMenu(IMenuManager m) {
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.populateContextMenu(m);
        }
    }

    @Override
    public Point getContextMenuLocation() {
        return this.m_view.getContextMenuLocation();
    }

    public void paint(GC gc) {
        gc.fillRectangle(this.getClientArea());
        if (this.m_visualizers == null || this.m_visualizers.size() == 0) {
            String noVisualizersMessage = CDTVisualizerUIPlugin.getString("VisualizerViewer.no.visualizers.defined");
            gc.drawString("(" + noVisualizersMessage + ")", 10, 10);
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionManager.addSelectionChangedListener(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.m_selectionManager != null) {
            this.m_selectionManager.removeSelectionChangedListener(listener);
        }
    }

    public void raiseSelectionChangedEvent() {
        this.m_selectionManager.raiseSelectionChangedEvent();
    }

    @Override
    public ISelection getSelection() {
        return this.m_selectionManager.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.m_selectionManager.setSelection(selection);
    }

    public void updateVisualizerFromWorkbenchSelection() {
        ISelection selection = SelectionUtils.getWorkbenchSelection();
        this.workbenchSelectionChanged(selection);
    }

    @Override
    public void workbenchSelectionChanged(ISelection selection) {
        int w;
        IVisualizer handles = null;
        int weight = 0;
        if (this.m_currentVisualizer != null && (w = this.m_currentVisualizer.handlesSelection(selection)) > weight) {
            handles = this.m_currentVisualizer;
            weight = w;
        }
        for (IVisualizer v : this.m_visualizers.values()) {
            int w2;
            if (v == this.m_currentVisualizer || (w2 = v.handlesSelection(selection)) <= weight) continue;
            handles = v;
            weight = w2;
        }
        if (handles == null && this.m_visualizers.size() > 0) {
            handles = this.m_visualizers.values().iterator().next();
        }
        if (handles != null && handles != this.m_currentVisualizer) {
            this.selectVisualizer(handles);
        }
        if (this.m_currentVisualizer != null) {
            this.m_currentVisualizer.workbenchSelectionChanged(selection);
        }
    }

    public void updateWorkbenchFromVisualizerSelection() {
        this.m_selectionManager.raiseSelectionChangedEvent();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }
}

