/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.Messages;

public class DiscoveryPreferences {
    private static final String PREF_CACHE_FREQUENCY = "cache-frequency";
    private static final String PREF_CACHE_LAST_UPDATED_DATE = "cache-lastUpdatedDate";
    private Preferences preferences = Activator.getDefault().getPluginPreferences();
    private static DiscoveryPreferences instance;

    private DiscoveryPreferences() {
        this.setDefaults();
    }

    public static DiscoveryPreferences getInstance() {
        if (instance == null) {
            instance = new DiscoveryPreferences();
        }
        return instance;
    }

    private void setDefaults() {
        this.preferences.setDefault(PREF_CACHE_FREQUENCY, 2);
        this.preferences.setDefault(PREF_CACHE_LAST_UPDATED_DATE, Messages.cacheUpdate_Never);
    }

    public int getCacheFrequency() {
        return this.preferences.getInt(PREF_CACHE_FREQUENCY);
    }

    public void setCacheFrequency(int frequency) {
        this.preferences.setValue(PREF_CACHE_FREQUENCY, frequency);
        Activator.getDefault().savePluginPreferences();
    }

    public String getCacheLastUpdatedDate() {
        return this.preferences.getString(PREF_CACHE_LAST_UPDATED_DATE);
    }

    public void setCacheLastUpdatedDate(String lastUpdateDate) {
        this.preferences.setValue(PREF_CACHE_LAST_UPDATED_DATE, lastUpdateDate);
        Activator.getDefault().savePluginPreferences();
    }
}

