/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IPreferredSizeProvider;
import org.eclipse.wb.internal.draw2d.IRootFigure;

public class RootFigure
extends Figure
implements IRootFigure {
    private final FigureCanvas m_figureCanvas;
    private final Rectangle m_dirtyRegion = new Rectangle();
    @Deprecated
    private final UpdateManager m_updateManager;
    private Dimension m_preferredSize;
    private Map<String, Layer> m_nameToLayer = new HashMap<String, Layer>();
    private IPreferredSizeProvider m_preferredSizeProvider;
    private boolean m_refreshWork;

    public RootFigure(final FigureCanvas figureCanvas) {
        this.m_figureCanvas = figureCanvas;
        this.m_updateManager = new DeferredUpdateManager();
        this.m_updateManager.addUpdateListener(new UpdateListener(){

            public void notifyPainting(Rectangle damage, Map dirtyRegions) {
                RootFigure.this.m_dirtyRegion.union(damage);
                if (figureCanvas != null && !RootFigure.this.m_figureCanvas.isDisposed() && !RootFigure.this.m_refreshWork) {
                    RootFigure.this.m_refreshWork = true;
                    RootFigure.this.m_figureCanvas.handleRefresh(RootFigure.this.m_dirtyRegion.x, RootFigure.this.m_dirtyRegion.y, RootFigure.this.m_dirtyRegion.width, RootFigure.this.m_dirtyRegion.height);
                    RootFigure.this.m_dirtyRegion.setBounds(0, 0, 0, 0);
                    RootFigure.this.m_refreshWork = false;
                }
            }

            public void notifyValidating() {
            }
        });
        this.setOpaque(true);
    }

    public void setPreferredSizeProvider(IPreferredSizeProvider provider) {
        this.m_preferredSizeProvider = provider;
    }

    public EventDispatcher internalGetEventDispatcher() {
        return this.m_figureCanvas.getLightweightSystem().getRootFigure().internalGetEventDispatcher();
    }

    @Override
    public FigureCanvas getFigureCanvas() {
        return this.m_figureCanvas;
    }

    public UpdateManager getUpdateManager() {
        return this.m_updateManager;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.m_preferredSize == null) {
            Rectangle preferred = new Rectangle();
            for (Layer layer : this.getLayers()) {
                for (IFigure figure : layer.getChildren()) {
                    if (!figure.isVisible()) continue;
                    if (figure instanceof IPreferredSizeProvider) {
                        IPreferredSizeProvider provider = (IPreferredSizeProvider)figure;
                        Dimension figurePreferredSize = provider.getPreferredSize(null);
                        preferred.union(0, 0, figurePreferredSize.width, figurePreferredSize.height);
                        continue;
                    }
                    preferred.union(figure.getBounds());
                }
            }
            this.m_preferredSize = this.m_preferredSizeProvider == null ? preferred.getSize() : this.m_preferredSizeProvider.getPreferredSize(preferred.getSize());
        }
        return this.m_preferredSize;
    }

    public void setBounds(Rectangle bounds) {
        Rectangle value = this.getBounds().setBounds(bounds).union(this.getPreferredSize());
        for (Layer layer : this.getLayers()) {
            layer.setBounds(value);
        }
    }

    public void repaint(int x, int y, int width, int height) {
        this.m_updateManager.addDirtyRegion((IFigure)this, x, y, width, height);
    }

    public void invalidate() {
        this.m_preferredSize = null;
        super.invalidate();
    }

    @Override
    public void addLayer(Layer layer) {
        this.m_nameToLayer.put(layer.getName(), layer);
        this.add((IFigure)layer, null, -1);
    }

    @Override
    public void addLayer(Layer layer, int index) {
        this.m_nameToLayer.put(layer.getName(), layer);
        this.add((IFigure)layer, null, index);
    }

    @Override
    public Layer getLayer(String name) {
        return this.m_nameToLayer.get(name);
    }

    @Override
    public List<Layer> getLayers() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (IFigure childFigure : this.getChildren()) {
            layers.add((Layer)childFigure);
        }
        return layers;
    }

    @Override
    public void removeLayer(String name) {
        this.removeLayer(this.getLayer(name));
    }

    @Override
    public void removeLayer(Layer layer) {
        this.m_nameToLayer.remove(layer.getName());
        this.remove((IFigure)layer);
    }

    @Override
    public void removeAll() {
        this.m_nameToLayer = new HashMap<String, Layer>();
        super.removeAll();
    }
}

