/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.internal.draw2d.FigureCanvas;

public class FigureUtils {
    public static void removeFigure(Figure figure) {
        if (figure != null && figure.getParent() != null) {
            figure.getParent().remove((IFigure)figure);
        }
    }

    public static final void translateFigureToFigure(IFigure source, IFigure target, Translatable translatable) {
        FigureUtils.translateFigureToAbsolute(source, translatable);
        FigureUtils.translateAbsoluteToFigure(target, translatable);
    }

    public static final void translateFigureToFigure2(IFigure source, IFigure target, Translatable translatable) {
        FigureUtils.translateFigureToAbsolute2(source, translatable);
        FigureUtils.translateAbsoluteToFigure2(target, translatable);
    }

    public static final void translateFigureToAbsolute(IFigure figure, Translatable translatable) {
        IFigure parent = figure.getParent();
        while (parent != null) {
            translatable.performTranslate(parent.getInsets());
            translatable.performTranslate(parent.getLocation());
            parent = parent.getParent();
        }
    }

    public static final void translateFigureToAbsolute2(IFigure figure, Translatable translatable) {
        while (figure != null) {
            translatable.performTranslate(figure.getInsets());
            translatable.performTranslate(figure.getLocation());
            figure = figure.getParent();
        }
    }

    public static final void translateFigureToCanvas(Figure figure, Translatable translatable) {
        FigureUtils.translateFigureToAbsolute2((IFigure)figure, translatable);
        FigureCanvas figureCanvas = figure.getFigureCanvas();
        translatable.performTranslate(-figureCanvas.getViewport().getHorizontalRangeModel().getValue(), -figureCanvas.getViewport().getVerticalRangeModel().getValue());
    }

    public static final void translateAbsoluteToFigure(IFigure figure, Translatable translatable) {
        IFigure parent = figure.getParent();
        while (parent != null) {
            translatable.performTranslate(parent.getLocation().negate());
            translatable.performTranslate(parent.getInsets().getNegated());
            parent = parent.getParent();
        }
    }

    public static final void translateAbsoluteToFigure2(IFigure figure, Translatable translatable) {
        while (figure != null) {
            translatable.performTranslate(figure.getLocation().negate());
            translatable.performTranslate(figure.getInsets().getNegated());
            figure = figure.getParent();
        }
    }

    public static Dimension calculateTextSize(String text, Font font) {
        GC gc = FigureUtils.createGC();
        try {
            gc.setFont(font);
            Point size = gc.textExtent(text);
            Dimension dimension = new Dimension(size);
            return dimension;
        }
        finally {
            gc.dispose();
        }
    }

    public static GC createGC() {
        Display display = Display.getCurrent();
        if (display == null) {
            return new GC((Drawable)Display.getDefault());
        }
        Shell shell = display.getActiveShell();
        if (shell == null) {
            return new GC((Drawable)display);
        }
        return new GC((Drawable)shell);
    }
}

