/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;
import org.eclipse.ocl.examples.eventmanager.framework.AdapterCapsule;
import org.eclipse.ocl.examples.eventmanager.framework.CleanupThread;
import org.eclipse.ocl.examples.eventmanager.framework.DeferringNotifier;
import org.eclipse.ocl.examples.eventmanager.framework.EventAdapter;
import org.eclipse.ocl.examples.eventmanager.framework.ListenerTypeEnum;
import org.eclipse.ocl.examples.eventmanager.framework.RegistrationManagerTableBased;

public class EventManagerTableBased
implements EventManager {
    private Logger logger = Logger.getLogger(EventManagerTableBased.class.getName());
    private boolean active = true;
    private final EventAdapter adapter = new EventAdapter(this);
    private boolean doFireEvents = true;
    protected WeakHashMap<Adapter, Collection<AdapterCapsule>> notifierByListener = new WeakHashMap();
    private Collection<AdapterCapsule> allNotifiers = new LinkedList<AdapterCapsule>();
    private final RegistrationManagerTableBased registrationManager;
    private final WeakHashMap<ResourceSet, Object> resourceSets;
    private final ReferenceQueue<Adapter> adaptersNoLongerStronglyReferenced = new ReferenceQueue();
    private CleanupThread adapterCleanupThread;
    private static final ListenerTypeEnum listenersForNotifier = new ListenerTypeEnum(ListenerTypeEnum.postChange, ListenerTypeEnum.preChange);
    private static final ListenerTypeEnum listenersForDeferringNotifier = new ListenerTypeEnum(ListenerTypeEnum.postCommit, ListenerTypeEnum.preCommit);
    private static final ListenerTypeEnum allCommitListenerTypes = new ListenerTypeEnum(ListenerTypeEnum.preCommit, ListenerTypeEnum.postCommit);

    public void setFireEvents(boolean doFireEventsValue) {
        this.doFireEvents = doFireEventsValue;
    }

    public EventManagerTableBased(ResourceSet set) {
        this();
        this.addToObservedResourceSets(set);
    }

    public EventManagerTableBased() {
        this.resourceSets = new WeakHashMap();
        this.registrationManager = new RegistrationManagerTableBased();
        this.adapterCleanupThread = new CleanupThread(this.adaptersNoLongerStronglyReferenced, this);
        this.adapterCleanupThread.start();
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void subscribe(EventFilter eventFilterTree, Adapter listener) {
        this.register(listener, (AbstractEventFilter)eventFilterTree, ListenerTypeEnum.postChange);
    }

    public void registerPreChangeListener(Adapter listener, AbstractEventFilter eventFilterTree) {
        this.register(listener, eventFilterTree, ListenerTypeEnum.preChange);
    }

    public void registerCommitListener(Adapter listener, AbstractEventFilter eventFilterTree) {
        this.register(listener, eventFilterTree, ListenerTypeEnum.postCommit);
    }

    public void registerPreCommitListener(Adapter listener, AbstractEventFilter eventFilterTree) {
        this.register(listener, eventFilterTree, ListenerTypeEnum.preCommit);
    }

    private void register(Adapter listener, AbstractEventFilter eventFilterTree, ListenerTypeEnum listenerType) {
        if (listener == null) {
            throw new IllegalArgumentException("Event listener must not be null");
        }
        if (eventFilterTree == null) {
            throw new IllegalArgumentException("Event filter must not be null");
        }
        WeakReference<Adapter> listenerRef = new WeakReference<Adapter>(listener, this.adaptersNoLongerStronglyReferenced);
        this.registrationManager.register(eventFilterTree.clone(), listenerRef, listenerType);
        AdapterCapsule notifier = null;
        if (listenerType.matches(listenersForNotifier)) {
            notifier = new AdapterCapsule(listenerRef, listenerType, this);
        } else if (listenerType.matches(listenersForDeferringNotifier)) {
            notifier = new DeferringNotifier(listenerRef, listenerType, this);
        } else {
            this.logger.warning("Unkown listenerType " + listenerType);
        }
        this.addNotifierForListener(notifier);
    }

    public void deregister(Adapter listener) {
        this.registrationManager.deregister(listener);
        this.removeListener(listener);
    }

    void deregister(Reference<? extends Adapter> listenerRef) {
        Adapter adapter = listenerRef.get();
        if (adapter == null) {
            this.registrationManager.deregister(listenerRef);
        } else {
            this.deregister(adapter);
        }
    }

    public void fireChangeEvent(Notification event) {
        if (!this.doFireEvents) {
            return;
        }
        this.fireEvent(event);
    }

    public void firePreChangeEvent(Notification event) {
        if (!this.doFireEvents) {
            return;
        }
        this.fireEvent(event);
    }

    public void beginCommand() {
        if (!this.doFireEvents) {
            return;
        }
        for (AdapterCapsule notifier : this.allNotifiers) {
            notifier.deferNotification();
        }
    }

    public void postCommitCommand() {
        if (!this.doFireEvents) {
            return;
        }
        for (AdapterCapsule notifier : this.allNotifiers) {
            if (!notifier.getListenerType().matches(ListenerTypeEnum.postCommit)) continue;
            notifier.deliverDeferredEvents();
        }
    }

    public void preCommitCommand() {
        if (!this.doFireEvents) {
            return;
        }
        for (AdapterCapsule notifier : this.allNotifiers) {
            if (!notifier.getListenerType().matches(ListenerTypeEnum.preCommit)) continue;
            notifier.deliverDeferredEvents();
        }
    }

    public void cancelCommand() {
        if (!this.doFireEvents) {
            return;
        }
        for (AdapterCapsule notifier : this.allNotifiers) {
            if (!notifier.getListenerType().matches(allCommitListenerTypes)) continue;
            notifier.cancelDeferment();
        }
    }

    private void fireEvent(Notification event) {
        Collection<WeakReference<? extends Adapter>> listeners = this.registrationManager.getListenersFor(event);
        for (WeakReference<? extends Adapter> listenerRef : listeners) {
            AdapterCapsule notifier = this.getNotifierForListener(listenerRef, ListenerTypeEnum.postChange);
            if (notifier == null) continue;
            notifier.fireEvent(event);
        }
    }

    private void addNotifierForListener(AdapterCapsule notifier) {
        Adapter adapter = (Adapter)notifier.getListener().get();
        if (adapter == null) {
            this.logger.warning("listener " + notifier.getListener() + " got GCed; AdapterCapsule: " + notifier);
        } else {
            Collection<AdapterCapsule> notifiers = this.notifierByListener.get(adapter);
            if (notifiers == null) {
                notifiers = new LinkedList<AdapterCapsule>();
                this.notifierByListener.put(adapter, notifiers);
            }
            notifiers.add(notifier);
            this.allNotifiers.add(notifier);
        }
    }

    private void removeListener(Adapter listener) {
        Collection<AdapterCapsule> removedNotifiers = this.notifierByListener.get(listener);
        if (removedNotifiers != null) {
            this.allNotifiers.removeAll(removedNotifiers);
        }
        this.notifierByListener.remove(listener);
    }

    private AdapterCapsule getNotifierForListener(WeakReference<? extends Adapter> listener, ListenerTypeEnum listenerType) {
        Adapter adapter = (Adapter)listener.get();
        if (adapter == null) {
            this.logger.warning("No notifier found for listener " + listener);
        } else {
            Collection<AdapterCapsule> notifiers = this.notifierByListener.get(adapter);
            if (notifiers == null) {
                this.logger.warning("No notifiers found");
                return null;
            }
            for (AdapterCapsule notifier : notifiers) {
                if (!notifier.isResponsibleFor(adapter, listenerType)) continue;
                return notifier;
            }
        }
        this.logger.warning("No notifier found");
        return null;
    }

    @Override
    public void handleEMFEvent(Notification notification) {
        if (this.active && !this.notifierByListener.isEmpty()) {
            for (Notification n : EventManagerFactory.eINSTANCE.createNotificationForComposites(notification)) {
                this.fireChangeEvent(n);
            }
        }
    }

    @Override
    public boolean unsubscribe(Adapter caller) {
        this.deregister(caller);
        return true;
    }

    protected void finalize() throws Throwable {
        this.adapterCleanupThread.stopCleaner();
        for (ResourceSet rs : this.resourceSets.keySet()) {
            if (rs == null || this.adapter == null) continue;
            rs.eAdapters().remove((Object)this.adapter);
        }
        super.finalize();
    }

    public String toString() {
        return this.registrationManager.toString();
    }

    @Override
    public void addToObservedResourceSets(ResourceSet resourceSet) {
        if (!resourceSet.eAdapters().contains((Object)this.adapter)) {
            resourceSet.eAdapters().add((Object)this.adapter);
        }
        this.resourceSets.put(resourceSet, null);
    }

    @Override
    public void removeFromObservedResourceSets(ResourceSet resourceSet) {
        resourceSet.eAdapters().remove((Object)this.adapter);
        this.resourceSets.remove(resourceSet);
    }
}

