/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.TclForeachStatement;

public class TclForeachCommandProcessor
extends AbstractTclCommandProcessor {
    private static final int MIN_ARG_NUMBER = 3;

    @Override
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        TclForeachStatement foreach = new TclForeachStatement(statement.sourceStart(), statement.sourceEnd());
        this.addToParent(parent, (ASTNode)foreach);
        if (statement.getCount() % 2 != 0 || statement.getCount() < 4) {
            this.report(parser, "Syntax error: wrong number of arguments", (ASTNode)statement, ProblemSeverities.Error);
        } else {
            Expression procCode = statement.getAt(statement.getCount() - 1);
            if (procCode instanceof Block) {
                foreach.acceptBlock((Block)procCode);
            } else if (procCode instanceof TclBlockExpression) {
                Block block = new Block(procCode.sourceStart(), procCode.sourceEnd());
                String content = ((TclBlockExpression)procCode).getBlock();
                if (content.startsWith("{") && content.endsWith("}")) {
                    content = content.substring(1, content.length() - 1);
                }
                foreach.acceptBlock(block);
                parser.parse(content, procCode.sourceStart() + 1 - parser.getStartPos(), (ASTNode)block);
            }
        }
        return foreach;
    }
}

