/*******************************************************************************
 * Copyright (c) 2011, 2017 NumberFour AG
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     NumberFour AG - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.eclipse.dltk.internal.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.builder.IBuildState;

abstract class AbstractBuildState implements IBuildState {

	private final String projectName;

	public AbstractBuildState(String projectName) {
		this.projectName = projectName;
	}

	private final Set<IPath> structuralChanges = new HashSet<>();

	@Override
	public void recordStructuralChange(IPath path) {
		Assert.isLegal(projectName.equals(path.segment(0)));
		structuralChanges.add(path);
	}

	public void recordStructuralChanges(Collection<IPath> paths) {
		for (IPath path : paths) {
			recordStructuralChange(path);
		}
	}

	@Override
	public Set<IPath> getStructuralChanges() {
		return Collections.unmodifiableSet(structuralChanges);
	}

	public void resetStructuralChanges() {
		structuralChanges.clear();
	}

	@Override
	public final void recordDependency(IPath path, IPath dependency) {
		recordDependency(path, dependency, STRUCTURAL);
	}
}
