/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddImportAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddInterfaceAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddMessageAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddSchemaAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddServiceAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ICategoryAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class W11CategoryAdapter
extends WSDLBaseAdapter
implements ICategoryAdapter,
ITreeElement,
IASDObjectListener {
    public static final int IMPORTS = 1;
    public static final int TYPES = 2;
    public static final int SERVICES = 3;
    public static final int BINDINGS = 5;
    public static final int INTERFACES = 6;
    public static final int MESSAGES = 7;
    public static String IMPORTS_HEADER_TEXT = Messages._UI_FOLDER_IMPORTS;
    public static String TYPES_HEADER_TEXT = Messages._UI_FOLDER_TYPES;
    public static String SERVICE_HEADER_TEXT = Messages._UI_FOLDER_SERVICES;
    public static String BINDING_HEADER_TEXT = Messages._UI_FOLDER_BINDINGS;
    public static String INTERFACE_HEADER_TEXT = Messages.INTERFACE_HEADER_TEXT;
    public static String MESSAGE_HEADER_TEXT = Messages._UI_FOLDER_MESSAGES;
    protected String text;
    protected Image image;
    protected int groupType;
    protected Collection children;
    protected IDescription description;

    public W11CategoryAdapter(IDescription description, String label, Image image, Collection children, int groupType) {
        this.text = label;
        this.image = image;
        this.description = description;
        this.target = ((W11Description)description).getTarget();
        this.children = children;
        this.groupType = groupType;
    }

    public Definition getDefinition() {
        return (Definition)this.target;
    }

    @Override
    public IDescription getOwnerDescription() {
        return this.description;
    }

    public int getGroupType() {
        return this.groupType;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ITreeElement[] getChildren() {
        return this.children.toArray(new ITreeElement[0]);
    }

    public void setChildren(Collection list) {
        this.children = list;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    @Override
    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        switch (this.groupType) {
            case 1: {
                actionIDs.add(ASDAddImportAction.ID);
                break;
            }
            case 2: {
                actionIDs.add(ASDAddSchemaAction.ID);
                break;
            }
            case 3: {
                actionIDs.add(ASDAddServiceAction.ID);
                break;
            }
            case 5: {
                actionIDs.add(ASDAddBindingAction.ID);
                break;
            }
            case 6: {
                actionIDs.add(ASDAddInterfaceAction.ID);
                break;
            }
            case 7: {
                actionIDs.add(ASDAddMessageAction.ID);
            }
        }
        return actionIDs.toArray(new String[0]);
    }

    @Override
    public void propertyChanged(Object object, String property) {
        if (this.getText().equals(property)) {
            this.notifyListeners(this, property);
        }
    }

    @Override
    public ITreeElement getParent() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }
}

