/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef.header.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.MigLayout.gef.MigLayoutEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swing.MigLayout.gef.header.selection.ColumnSelectionEditPolicy;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;

public final class ColumnsLayoutEditPolicy
extends AbstractHeaderLayoutEditPolicy {
    private final MigLayoutEditPolicy m_mainPolicy;
    private final MigLayoutInfo m_layout;
    private final Figure m_insertFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private TextFeedback m_feedback;
    private Command m_moveCommand;

    public ColumnsLayoutEditPolicy(MigLayoutEditPolicy mainPolicy, MigLayoutInfo layout) {
        super((LayoutEditPolicy)mainPolicy);
        this.m_mainPolicy = mainPolicy;
        this.m_layout = layout;
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new ColumnSelectionEditPolicy((LayoutEditPolicy)this.m_mainPolicy));
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (!this.m_layout.canChangeDimensions()) {
            return null;
        }
        return this.m_moveCommand;
    }

    protected void showLayoutTargetFeedback(Request request) {
        int x;
        int targetIndex;
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        ColumnHeaderEditPart headerEditPart = (ColumnHeaderEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        DropRequest dropRequest = (DropRequest)request;
        Point location = dropRequest.getLocation().getCopy();
        ColumnHeaderEditPart target = null;
        for (EditPart editPart : this.getHost().getChildren()) {
            ColumnHeaderEditPart columnEditPart = (ColumnHeaderEditPart)editPart;
            Rectangle bounds = columnEditPart.getFigure().getBounds();
            if (location.x >= bounds.getCenter().x) continue;
            target = columnEditPart;
            break;
        }
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int y1 = rowIntervals[0].begin() - 5;
        int y2 = rowIntervals[rowIntervals.length - 1].end() + 5;
        int size = 7;
        if (target != null) {
            targetIndex = target.getIndex();
            x = columnIntervals[targetIndex].begin() - size / 2;
            if (targetIndex != 0) {
                x -= (columnIntervals[targetIndex].begin() - columnIntervals[targetIndex - 1].end()) / 2;
            }
        } else {
            targetIndex = this.m_layout.getColumns().size();
            x = columnIntervals[columnIntervals.length - 1].end() - size / 2;
        }
        this.m_mainPolicy.showInsertFeedbacks(new Rectangle(x, y1, size, y2 - y1), null);
        if (this.m_insertFeedback.getParent() == null) {
            this.addFeedback(this.m_insertFeedback);
        }
        Point offset = headerEditPart.getOffset();
        Rectangle bounds = new Rectangle(x + offset.x, 0, size, this.getHostFigure().getSize().height);
        this.m_insertFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new TextFeedback(feedbackLayer);
            this.m_feedback.add();
        }
        Point feedbackLocation = new Point(location.x + 30, 10);
        FigureUtils.translateAbsoluteToFigure((IFigure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_feedback.setText(GefMessages.ColumnsLayoutEditPolicy_columnPrefix + targetIndex);
        final int sourceIndex = headerEditPart.getIndex();
        this.m_moveCommand = new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                ColumnsLayoutEditPolicy.this.m_layout.moveColumn(sourceIndex, targetIndex);
            }
        };
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.m_mainPolicy.eraseInsertFeedbacks();
        FigureUtils.removeFigure((Figure)this.m_insertFeedback);
        if (this.m_feedback != null) {
            this.m_feedback.remove();
            this.m_feedback = null;
        }
    }
}

