/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.CastedSuperInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedFieldCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class JavaInfoResolver {
    private final EditorState m_editorState;
    private final CompilationUnit m_unit;
    private final List<JavaInfo> m_components = new ArrayList<JavaInfo>();
    private boolean m_thisJavaInfoReady = false;
    private JavaInfo m_thisJavaInfo = null;
    private JavaInfo m_rootJavaInfo = null;
    private final Set<Expression> m_expressions = new HashSet<Expression>();
    private static final String KEY_COMPONENTS_STAMP = "JavaInfoResolver.components.stamp";

    public JavaInfoResolver(AstEditor editor) {
        this.m_editorState = EditorState.get(editor);
        this.m_editorState.setJavaInfoResolver(this);
        this.m_unit = editor.getAstUnit();
    }

    public void setRootJavaInfo(JavaInfo rootJavaInfo) {
        this.m_rootJavaInfo = rootJavaInfo;
    }

    public void addJavaInfo(JavaInfo javaInfo, Expression creation) {
        this.m_components.add(javaInfo);
        if (creation != null) {
            this.bind(javaInfo, creation);
        }
    }

    public void bind(JavaInfo javaInfo, Expression expression) {
        ExpressionValue value = ExecutionFlowUtils2.ensurePermanentValue(expression);
        value.setModel(javaInfo);
    }

    public static JavaInfo getJavaInfo(JavaInfo someJavaInfo, Expression expression) {
        Assert.isNotNull((Object)((Object)someJavaInfo));
        EditorState editorState = EditorState.get(someJavaInfo.getEditor());
        JavaInfoResolver resolver = editorState.getJavaInfoResolver();
        return resolver.getJavaInfo(expression);
    }

    public JavaInfo getJavaInfo(Expression expression) {
        if (this.m_expressions.contains(expression)) {
            return null;
        }
        try {
            this.m_expressions.add(expression);
            JavaInfo javaInfo = this.getJavaInfo0(expression);
            return javaInfo;
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
        finally {
            this.m_expressions.remove(expression);
        }
    }

    /*
     * WARNING - void declaration
     */
    private JavaInfo getJavaInfo0(Expression expression) throws Exception {
        Object invName;
        Expression expression2;
        if (expression instanceof NullLiteral || expression instanceof BooleanLiteral || expression instanceof NumberLiteral || expression instanceof StringLiteral || expression instanceof TypeLiteral || expression instanceof Assignment || expression instanceof ArrayCreation || expression instanceof ArrayInitializer) {
            return null;
        }
        if (expression == null || expression instanceof ThisExpression) {
            if (!this.m_thisJavaInfoReady) {
                this.m_thisJavaInfoReady = true;
                for (JavaInfo javaInfo : this.getComponents()) {
                    if (!(javaInfo.getCreationSupport() instanceof ThisCreationSupport)) continue;
                    this.m_thisJavaInfo = javaInfo;
                    break;
                }
            }
            if (this.m_thisJavaInfo != null) {
                this.m_thisJavaInfo.addRelatedNode((ASTNode)expression);
            }
            return this.m_thisJavaInfo;
        }
        ExecutionFlowDescription executionFlowDescription = this.m_editorState.getFlowDescription();
        ExpressionValue value = ExecutionFlowUtils2.getValue(executionFlowDescription, expression);
        if (value != null) {
            JavaInfo javaInfo = value.getModel();
            if (javaInfo != null) {
                boolean expressionPartOfCasted;
                boolean bl = expressionPartOfCasted = javaInfo.getCreationSupport() instanceof CastedSuperInvocationCreationSupport && expression.getLocationInParent() == CastExpression.EXPRESSION_PROPERTY;
                if (!expressionPartOfCasted) {
                    javaInfo.addRelatedNode((ASTNode)expression);
                }
                return javaInfo;
            }
            Expression newExpression = value.getExpression();
            if (newExpression instanceof ThisExpression && newExpression != expression) {
                return this.getJavaInfo0(newExpression);
            }
        }
        if (AstNodeUtils.isSuccessorOf(expression, "org.eclipse.ui.forms.widgets.FormToolkit")) {
            for (JavaInfo javaInfo : this.getComponents()) {
                if (!(javaInfo instanceof InstanceFactoryInfo) || !javaInfo.getCreationSupport().isJavaInfo((ASTNode)expression)) continue;
                ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(javaInfo);
                javaInfo.addRelatedNode((ASTNode)expression);
                return javaInfo;
            }
        }
        if ((expression2 = expression) instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)expression2;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)expression2;
            invName = methodInvocation.getName().getIdentifier();
            if (((String)invName).equals("get") && AstNodeUtils.isSuccessorOf((Expression)methodInvocation, "com.google.gwt.user.client.ui.RootPanel")) {
                for (JavaInfo component2 : this.getComponents()) {
                    if (!component2.getCreationSupport().isJavaInfo((ASTNode)methodInvocation)) continue;
                    ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(component2);
                    component2.addRelatedNode((ASTNode)expression);
                    return component2;
                }
            }
            if (((String)invName).startsWith("get")) {
                JavaInfo expressionJavaInfo = this.getJavaInfo(methodInvocation.getExpression());
                Object result = this.getExposedJavaInfo(expressionJavaInfo, methodInvocation);
                if (result != null) {
                    return result;
                }
                JavaInfo javaInfo = expressionJavaInfo;
                if (javaInfo instanceof IWrapperInfo) {
                    void wrapperInfo;
                    result = (IWrapperInfo)((Object)javaInfo);
                    IWrapperInfo cfr_ignored_1 = (IWrapperInfo)((Object)javaInfo);
                    IWrapper wrapper = wrapperInfo.getWrapper();
                    JavaInfo javaInfo2 = wrapper.getWrappedInfo();
                    if (wrapper.isWrappedInfo((ASTNode)methodInvocation)) {
                        ExecutionFlowUtils2.ensurePermanentValue(expression).setModel(javaInfo2);
                        javaInfo2.addRelatedNode((ASTNode)expression);
                        return javaInfo2;
                    }
                }
            }
            return null;
        }
        Expression expression3 = expression;
        if (expression3 instanceof SimpleName) {
            void simpleName;
            invName = (SimpleName)expression3;
            SimpleName cfr_ignored_2 = (SimpleName)expression3;
            JavaInfo thisJavaInfo = this.getJavaInfo(null);
            String fieldName = simpleName.getIdentifier();
            return this.getExposedJavaInfo(thisJavaInfo, expression, fieldName);
        }
        Expression expression4 = expression;
        if (expression4 instanceof QualifiedName) {
            void qualifiedName;
            QualifiedName thisJavaInfo = (QualifiedName)expression4;
            QualifiedName cfr_ignored_3 = (QualifiedName)expression4;
            JavaInfo hostJavaInfo = this.getJavaInfo((Expression)qualifiedName.getQualifier());
            String fieldName = qualifiedName.getName().getIdentifier();
            return this.getExposedJavaInfo(hostJavaInfo, expression, fieldName);
        }
        return null;
    }

    private JavaInfo getExposedJavaInfo(JavaInfo parent, MethodInvocation invocation) {
        JavaInfo result;
        CreationSupport childCreationSupport;
        if (parent == null) {
            return null;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || !childCreationSupport.isJavaInfo((ASTNode)invocation)) continue;
            ExecutionFlowUtils2.ensurePermanentValue((Expression)invocation).setModel(child);
            child.addRelatedNode((ASTNode)invocation);
            return child;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || (result = this.getExposedJavaInfo(child, invocation)) == null) continue;
            return result;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof WrapperMethodControlCreationSupport) || (result = this.getExposedJavaInfo(child, invocation)) == null) continue;
            return result;
        }
        String expectedSetName = "set" + invocation.getName().getIdentifier().substring(3);
        for (MethodInvocation parentInvocation : parent.getMethodInvocations()) {
            Expression setExpression;
            JavaInfo result2;
            String setName;
            if (parentInvocation.arguments().size() != 1 || !(setName = parentInvocation.getName().getIdentifier()).equals(expectedSetName) || (result2 = this.getJavaInfo(setExpression = DomGenerics.arguments(parentInvocation).get(0))) == null) continue;
            ExecutionFlowUtils2.ensurePermanentValue((Expression)invocation).setModel(result2);
            result2.addRelatedNode((ASTNode)invocation);
            return result2;
        }
        return null;
    }

    private JavaInfo getExposedJavaInfo(JavaInfo parent, Expression expression, String fieldName) {
        if (parent == null) {
            return null;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            ExposedFieldCreationSupport cs;
            if (!(child.getCreationSupport() instanceof ExposedFieldCreationSupport) || !(cs = (ExposedFieldCreationSupport)child.getCreationSupport()).getField().getName().equals(fieldName)) continue;
            child.addRelatedNode((ASTNode)expression);
            return child;
        }
        for (JavaInfo child : parent.getChildrenJava()) {
            JavaInfo result;
            CreationSupport childCreationSupport = child.getCreationSupport();
            if (!(childCreationSupport instanceof IImplicitCreationSupport) || (result = this.getExposedJavaInfo(child, expression, fieldName)) == null) continue;
            return result;
        }
        return null;
    }

    public List<JavaInfo> getComponents() throws Exception {
        if (this.m_rootJavaInfo == null) {
            return this.m_components;
        }
        Long stampComponents = (Long)this.m_unit.getProperty(KEY_COMPONENTS_STAMP);
        long stampAST = this.m_unit.getAST().modificationCount();
        if (stampComponents == null || stampAST != stampComponents) {
            this.m_components.clear();
            this.m_rootJavaInfo.accept0(new ObjectInfoVisitor(){

                /*
                 * WARNING - void declaration
                 */
                public void endVisit(ObjectInfo objectInfo) throws Exception {
                    ObjectInfo objectInfo2 = objectInfo;
                    if (objectInfo2 instanceof JavaInfo) {
                        void javaInfo;
                        JavaInfo javaInfo2 = (JavaInfo)objectInfo2;
                        JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo2;
                        if (!this.isExplicitJavaInfo((JavaInfo)javaInfo)) {
                            return;
                        }
                        JavaInfoResolver.this.m_components.add((JavaInfo)javaInfo);
                    }
                }

                private boolean isExplicitJavaInfo(JavaInfo javaInfo) {
                    CreationSupport creationSupport = javaInfo.getCreationSupport();
                    return !(creationSupport instanceof IImplicitCreationSupport);
                }
            });
            this.m_unit.setProperty(KEY_COMPONENTS_STAMP, (Object)stampAST);
        }
        return this.m_components;
    }
}

