/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.filter.PropertyFilter;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveLabelProvider;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveTreeContentProvider;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

final class ObserveElementsComposite
extends SashForm {
    private final IDatabindingsProvider m_databindingsProvider;
    private final String m_title;
    private final Label m_titleLabel;
    private final Text m_filterText;
    private final ToolItem m_clearFilterAction;
    private final TreeViewer m_masterViewer;
    private boolean m_enabledFilter;
    private final ObserveFilter m_filter = new ObserveFilter();
    private final ToolItem m_propertiesFilterAction;
    private final ToolItem m_bindAction;
    private final TreeViewer m_propertiesViewer;
    private final Menu m_propertiesFilterMenu;
    private final PropertiesFilter m_propertiesFilter = new PropertiesFilter();
    private final List<ToolItem> m_typeActions = new ArrayList<ToolItem>();
    private final SelectionListener m_changeTypeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ObserveType type;
            ToolItem action = (ToolItem)e.widget;
            if (action.getSelection() && (type = (ObserveType)action.getData()) != ObserveElementsComposite.this.m_currentType) {
                ObserveElementsComposite.this.showPage(type, false);
            }
        }
    };
    private final Map<ObserveType, ISelection[]> m_typeToSelection = new HashMap<ObserveType, ISelection[]>();
    private final Map<ObserveType, Object[][]> m_typeToExpanded = new HashMap<ObserveType, Object[][]>();
    private ObserveType m_currentType;

    public ObserveElementsComposite(Composite parent, int style, String title, IDatabindingsProvider databindingsProvider, boolean addBindAction) {
        super(parent, style | 0x200);
        this.m_title = title;
        this.m_databindingsProvider = databindingsProvider;
        Composite masterComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.create((Composite)masterComposite).columns(2);
        this.m_titleLabel = new Label(masterComposite, 0);
        GridDataFactory.create((Control)this.m_titleLabel).fillH().grabH().spanH(2);
        this.m_titleLabel.setText(title);
        this.m_filterText = new Text(masterComposite, 2180);
        GridDataFactory.create((Control)this.m_filterText).fillH().grabH();
        this.m_filterText.setText(Messages.ObserveElementsComposite_filterText);
        this.m_filterText.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                ObserveElementsComposite.this.m_filterText.selectAll();
            }
        });
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = ObserveElementsComposite.this.m_filterText.getText();
                if (ObserveElementsComposite.this.m_enabledFilter) {
                    if (filterText.length() == 0) {
                        ObserveElementsComposite.this.m_enabledFilter = false;
                        ObserveElementsComposite.this.resetFilter();
                        ObserveElementsComposite.this.m_clearFilterAction.setEnabled(false);
                    } else {
                        ObserveElementsComposite.this.refreshFilter(filterText, false);
                    }
                } else {
                    ObserveElementsComposite.this.m_enabledFilter = true;
                    ObserveElementsComposite.this.refreshFilter(filterText, true);
                    ObserveElementsComposite.this.m_clearFilterAction.setEnabled(true);
                }
                ObserveElementsComposite.this.m_masterViewer.expandAll();
            }
        });
        ToolBar toolbar = new ToolBar(masterComposite, 0);
        this.m_clearFilterAction = new ToolItem(toolbar, 0);
        this.m_clearFilterAction.setImage(Activator.getImage("clear_filter.gif"));
        this.m_clearFilterAction.setToolTipText(Messages.ObserveElementsComposite_clearAction);
        this.m_clearFilterAction.setEnabled(false);
        this.m_clearFilterAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObserveElementsComposite.this.m_filterText.setText("");
            }
        });
        new ToolItem(toolbar, 2);
        for (ObserveType observeType : databindingsProvider.getTypes()) {
            ToolItem action = new ToolItem(toolbar, 16);
            action.setImage(observeType.getImage());
            action.setToolTipText(observeType.getName());
            action.setData((Object)observeType);
            action.addSelectionListener(this.m_changeTypeListener);
            this.m_typeActions.add(action);
        }
        this.m_masterViewer = new TreeViewer(masterComposite, 2816);
        GridDataFactory.create((Control)this.m_masterViewer.getControl()).fill().grab().spanH(2);
        this.m_masterViewer.setContentProvider((IContentProvider)new ObserveTreeContentProvider(IObserveInfo.ChildrenContext.ChildrenForMasterTable));
        this.m_masterViewer.setLabelProvider((IBaseLabelProvider)new ObserveLabelProvider());
        this.m_masterViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObserveElementsComposite.this.updatePageTitle();
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (UiUtils.isEmpty((ISelection)selection)) {
                    ObserveElementsComposite.this.m_propertiesViewer.setInput((Object)Collections.EMPTY_LIST);
                } else {
                    ObserveElementsComposite.this.m_propertiesViewer.setInput(selection.getFirstElement());
                }
            }
        });
        Composite propertiesComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.create((Composite)propertiesComposite).columns(2);
        Label propertiesLabel = new Label(propertiesComposite, 0);
        GridDataFactory.create((Control)propertiesLabel).fillH().grabH();
        propertiesLabel.setText(Messages.ObserveElementsComposite_propertiesLabel);
        ToolBar propertiesToolbar = new ToolBar(propertiesComposite, 0x800000);
        GridDataFactory.create((Control)propertiesToolbar).alignHR().grabH();
        this.m_propertiesFilterAction = new ToolItem(propertiesToolbar, 4);
        this.m_propertiesFilterAction.setImage(Activator.getImage("filter_action.gif"));
        this.m_propertiesFilterAction.setToolTipText(Messages.ObserveElementsComposite_propertiesFilterToolTip);
        this.m_propertiesFilterMenu = new Menu((Control)propertiesToolbar);
        this.m_propertiesFilterAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle bounds = ObserveElementsComposite.this.m_propertiesFilterAction.getBounds();
                Point location = ObserveElementsComposite.this.m_propertiesFilterAction.getParent().toDisplay(new Point(bounds.x, bounds.y + bounds.height));
                ObserveElementsComposite.this.m_propertiesFilterMenu.setLocation(location.x, location.y);
                ObserveElementsComposite.this.m_propertiesFilterMenu.setVisible(true);
            }
        });
        if (addBindAction) {
            new ToolItem(propertiesToolbar, 2);
            this.m_bindAction = new ToolItem(propertiesToolbar, 0);
            this.m_bindAction.setImage(Activator.getImage("link_add_action.png"));
            this.m_bindAction.setToolTipText(Messages.ObserveElementsComposite_bindToolTip);
            this.m_bindAction.setEnabled(false);
        } else {
            this.m_bindAction = null;
        }
        this.m_propertiesViewer = new TreeViewer(propertiesComposite, 2816);
        GridDataFactory.create((Control)this.m_propertiesViewer.getControl()).fill().grab().spanH(2);
        this.m_propertiesViewer.setContentProvider((IContentProvider)new ObserveTreeContentProvider(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable));
        IBaseLabelProvider propertiesLabelProvider = this.m_databindingsProvider.createPropertiesViewerLabelProvider(this.m_propertiesViewer);
        this.m_propertiesViewer.setLabelProvider((IBaseLabelProvider)(propertiesLabelProvider == null ? new ObserveLabelProvider() : propertiesLabelProvider));
        this.m_propertiesViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObserveElementsComposite.this.updatePageTitle();
            }
        });
        this.fillPropertiesFilters();
    }

    public void showPage(ObserveType type) {
        this.showPage(type, true);
    }

    private void showPage(ObserveType type, boolean setActionSelection) {
        ISelection[] selections;
        Object[][] expandeds;
        if (this.m_currentType != null && this.m_currentType != type) {
            this.storeSelection(this.m_currentType, this.m_masterViewer.getSelection(), this.m_propertiesViewer.getSelection());
            this.storeExpanded(this.m_currentType, this.m_masterViewer.getExpandedElements(), this.m_propertiesViewer.getExpandedElements());
        }
        boolean setInput = this.m_currentType != type;
        this.m_currentType = type;
        if (setActionSelection) {
            for (ToolItem action : this.m_typeActions) {
                action.setSelection(action.getData() == this.m_currentType);
            }
        }
        if (setInput) {
            this.updatePageTitle();
            this.m_masterViewer.setInput(this.m_databindingsProvider.getObserves(this.m_currentType));
            this.m_propertiesViewer.setInput((Object)Collections.EMPTY_LIST);
        }
        if ((expandeds = this.m_typeToExpanded.get(this.m_currentType)) == null || this.m_enabledFilter) {
            if (this.m_enabledFilter || this.m_currentType.getExpandedStrategy() == ObserveType.ExpandedStrategy.ExpandedAll) {
                this.m_masterViewer.expandAll();
            }
        } else {
            if (!this.m_enabledFilter) {
                this.m_masterViewer.setExpandedElements(expandeds[0]);
            }
            this.m_propertiesViewer.setExpandedElements(expandeds[1]);
        }
        if ((selections = this.m_typeToSelection.get(this.m_currentType)) != null) {
            this.m_masterViewer.setSelection(selections[0], true);
            this.m_propertiesViewer.setSelection(selections[1], true);
        }
    }

    private void updatePageTitle() {
        StringBuffer buffer = new StringBuffer();
        ObserveElementsComposite.appendObserves((Viewer)this.m_masterViewer, buffer);
        ObserveElementsComposite.appendObserves((Viewer)this.m_propertiesViewer, buffer);
        if (buffer.length() == 0) {
            buffer.append("<empty>");
        }
        this.m_titleLabel.setText(this.m_title + " (" + this.m_currentType.getName() + "): " + buffer.toString());
    }

    private static void appendObserves(Viewer viewer, StringBuffer commonBuffer) {
        IStructuredSelection selection = UiUtils.getSelection(viewer);
        if (!UiUtils.isEmpty((ISelection)selection)) {
            StringBuffer buffer = new StringBuffer();
            final IObserveInfo[] observe = new IObserveInfo[]{(IObserveInfo)selection.getFirstElement()};
            while (true) {
                buffer.insert(0, (String)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<String>(){

                    public String runObject() throws Exception {
                        return observe[0].getPresentation().getTextForBinding();
                    }
                }, (Object)"<error>"));
                observe[0] = observe[0].getParent();
                if (observe[0] == null) break;
                buffer.insert(0, ".");
            }
            if (commonBuffer.length() > 0 && buffer.length() > 0) {
                commonBuffer.append(".");
            }
            commonBuffer.append(buffer);
        }
    }

    public void setSelection(IObserveInfo observeObject, IObserveInfo observeProperty) {
        ObserveType type = observeObject.getType();
        StructuredSelection masterSelection = new StructuredSelection((Object)observeObject);
        StructuredSelection propertiesSelection = new StructuredSelection((Object)observeProperty);
        if (type == this.m_currentType && masterSelection.equals(this.m_masterViewer.getSelection()) && propertiesSelection.equals(this.m_propertiesViewer.getSelection())) {
            return;
        }
        this.storeSelection(type, (ISelection)masterSelection, (ISelection)propertiesSelection);
        this.showPage(type);
    }

    private void storeSelection(ObserveType type, ISelection masterSelection, ISelection propertiesSelection) {
        ISelection[] selections = this.m_typeToSelection.get(type);
        if (selections == null) {
            selections = new ISelection[2];
            this.m_typeToSelection.put(type, selections);
        }
        selections[0] = masterSelection;
        selections[1] = propertiesSelection;
    }

    private void storeExpanded(ObserveType type, Object[] masterExpandedObjects, Object[] propertiesExpandedObjects) {
        Object[][] expandeds = this.m_typeToExpanded.get(type);
        if (expandeds == null) {
            expandeds = new Object[2][];
            this.m_typeToExpanded.put(type, expandeds);
        }
        expandeds[0] = masterExpandedObjects;
        expandeds[1] = propertiesExpandedObjects;
    }

    public ToolItem getBindAction() {
        return this.m_bindAction;
    }

    public TreeViewer getMasterViewer() {
        return this.m_masterViewer;
    }

    public TreeViewer getPropertiesViewer() {
        return this.m_propertiesViewer;
    }

    public IObserveInfo getMasterObserve() {
        IStructuredSelection selection = (IStructuredSelection)this.m_masterViewer.getSelection();
        return UiUtils.isEmpty((ISelection)selection) ? null : (IObserveInfo)selection.getFirstElement();
    }

    public IObserveInfo getPropertyObserve() {
        IStructuredSelection selection = (IStructuredSelection)this.m_propertiesViewer.getSelection();
        return UiUtils.isEmpty((ISelection)selection) ? null : (IObserveInfo)selection.getFirstElement();
    }

    public ObserveType getCurrentType() {
        return this.m_currentType;
    }

    public void refresh() {
        this.m_masterViewer.refresh();
        this.m_propertiesViewer.refresh();
    }

    protected final void resetFilter() {
        try {
            this.m_masterViewer.getControl().setRedraw(false);
            this.m_masterViewer.resetFilters();
        }
        finally {
            this.m_masterViewer.getControl().setRedraw(true);
        }
    }

    protected final void refreshFilter(String filterText, boolean addFilter) {
        try {
            this.m_masterViewer.getControl().setRedraw(false);
            this.m_filter.setPattern(filterText);
            if (addFilter) {
                this.m_masterViewer.addFilter((ViewerFilter)this.m_filter);
            } else {
                this.m_masterViewer.refresh();
            }
        }
        finally {
            this.m_masterViewer.getControl().setRedraw(true);
        }
    }

    private void fillPropertiesFilters() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                if (item.getSelection()) {
                    PropertyFilter filter = (PropertyFilter)item.getData();
                    ObserveElementsComposite.this.m_propertiesFilter.setCurrentFilter(filter);
                    ObserveElementsComposite.this.m_propertiesViewer.refresh();
                }
            }
        };
        List<PropertyFilter> filters = this.m_databindingsProvider.getObservePropertyFilters();
        for (PropertyFilter filter : filters) {
            MenuItem item = new MenuItem(this.m_propertiesFilterMenu, 16);
            ImageDescriptor imageDescriptor = filter.getImageDescriptor();
            if (imageDescriptor != null) {
                Image image = imageDescriptor.createImage();
                item.addDisposeListener(event -> image.dispose());
                item.setImage(image);
            }
            item.setText(filter.getName());
            item.setData((Object)filter);
            item.addSelectionListener((SelectionListener)listener);
        }
        if (!filters.isEmpty()) {
            this.m_propertiesFilter.setCurrentFilter(filters.get(0));
            this.m_propertiesViewer.addFilter((ViewerFilter)this.m_propertiesFilter);
            this.m_propertiesFilterMenu.getItem(0).setSelection(true);
        }
    }

    private static class ObserveFilter
    extends ViewerFilter {
        private final SearchPattern m_matcher = new SearchPattern();

        private ObserveFilter() {
        }

        public void setPattern(String pattern) {
            this.m_matcher.setPattern(pattern);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            final IObserveInfo observe = (IObserveInfo)element;
            for (IObserveInfo child : observe.getChildren(IObserveInfo.ChildrenContext.ChildrenForMasterTable)) {
                if (!this.select(viewer, element, child)) continue;
                return true;
            }
            return (Boolean)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

                public Boolean runObject() throws Exception {
                    return m_matcher.matches(observe.getPresentation().getText());
                }
            }, (Object)Boolean.FALSE);
        }
    }

    private static class PropertiesFilter
    extends ViewerFilter {
        private PropertyFilter m_currentFilter;

        private PropertiesFilter() {
        }

        public void setCurrentFilter(PropertyFilter currentFilter) {
            this.m_currentFilter = currentFilter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.m_currentFilter != null) {
                return this.m_currentFilter.select(viewer, (IObserveInfo)element);
            }
            return true;
        }
    }
}

