/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.core.generator;

import com.google.inject.Inject;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternModel;
import org.eclipse.viatra.query.runtime.IExtensions;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.extensibility.SingletonExtensionFactory;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionData;
import org.eclipse.viatra.query.tooling.core.generator.ExtensionGenerator;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.w3c.dom.Element;

@SuppressWarnings("all")
public class GenerateQuerySpecificationExtension {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private ExtensionGenerator exGen;
  
  public List<ExtensionData> extensionContribution(final PatternModel model) {
    List<ExtensionData> _xblockexpression = null;
    {
      final JvmType groupClass = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(model, BaseGeneratedPatternGroup.class);
      List<ExtensionData> _xifexpression = null;
      if ((model.getPatterns().isEmpty() || (groupClass == null))) {
        _xifexpression = CollectionLiterals.<ExtensionData>newImmutableList();
      } else {
        final Procedure1<Element> _function = (Element it) -> {
          final Procedure1<Element> _function_1 = (Element it_1) -> {
            this.exGen.contribAttribute(it_1, "id", groupClass.getQualifiedName());
            String _canonicalName = SingletonExtensionFactory.class.getCanonicalName();
            String _plus = (_canonicalName + ":");
            String _qualifiedName = groupClass.getQualifiedName();
            String _plus_1 = (_plus + _qualifiedName);
            this.exGen.contribAttribute(it_1, "group", _plus_1);
            final Function1<Pattern, Boolean> _function_2 = (Pattern it_2) -> {
              return Boolean.valueOf(this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it_2));
            };
            final Function1<Pattern, String> _function_3 = (Pattern it_2) -> {
              return PatternLanguageHelper.getFullyQualifiedName(it_2);
            };
            final Consumer<String> _function_4 = (String fqn) -> {
              final Procedure1<Element> _function_5 = (Element it_2) -> {
                this.exGen.contribAttribute(it_2, "fqn", fqn);
              };
              this.exGen.contribElement(it_1, "query-specification", _function_5);
            };
            IterableExtensions.<Pattern, String>map(IterableExtensions.<Pattern>filterNull(IterableExtensions.<Pattern>filter(model.getPatterns(), _function_2)), _function_3).forEach(_function_4);
          };
          this.exGen.contribElement(it, "group", _function_1);
        };
        _xifexpression = CollectionLiterals.<ExtensionData>newImmutableList(
          this.exGen.contribExtension(groupClass.getQualifiedName(), IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID, _function));
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public static List<Pair<String, String>> getRemovableExtensionIdentifiers() {
    return CollectionLiterals.<Pair<String, String>>newImmutableList(
      Pair.<String, String>of("", IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID));
  }
}
