/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timely;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public class TimelyMailbox
implements Mailbox {
    protected TreeMap<Timestamp, Map<Tuple, Integer>> queue;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected CommunicationGroup group;
    protected boolean fallThrough;

    public TimelyMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.queue = CollectionsFactory.createTreeMap();
    }

    protected TreeMap<Timestamp, Map<Tuple, Integer>> getActiveQueue() {
        return this.queue;
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveQueue().isEmpty();
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        Integer count;
        TreeMap<Timestamp, Map<Tuple, Integer>> activeQueue = this.getActiveQueue();
        Map tupleMap = activeQueue.get(timestamp);
        boolean wasEmpty = tupleMap == null;
        boolean significantChange = false;
        if (tupleMap == null) {
            tupleMap = CollectionsFactory.createMap();
            activeQueue.put(timestamp, tupleMap);
            significantChange = true;
        }
        if ((count = (Integer)tupleMap.get(update)) == null) {
            count = 0;
            significantChange = true;
        }
        if ((count = direction == Direction.DELETE ? Integer.valueOf(count - 1) : Integer.valueOf(count + 1)) == 0) {
            tupleMap.remove(update);
            if (tupleMap.isEmpty()) {
                activeQueue.remove(timestamp);
            }
            significantChange = true;
        } else {
            tupleMap.put(update, count);
        }
        if (significantChange) {
            if (wasEmpty) {
                this.group.notifyHasMessage(this, timestamp);
            } else if (tupleMap.isEmpty()) {
                Timestamp resumableTimestamp;
                Timestamp timestamp2 = resumableTimestamp = this.receiver instanceof ResumableNode ? ((ResumableNode)((Object)this.receiver)).getResumableTimestamp() : null;
                if (resumableTimestamp == null || resumableTimestamp.compareTo(timestamp) != 0) {
                    this.group.notifyLostAllMessages(this, timestamp);
                }
            }
        }
    }

    @Override
    public void deliverAll(MessageSelector selector) {
        if (selector instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)selector;
            Map<Tuple, Integer> tupleMap = this.queue.remove(timestamp);
            if (tupleMap != null) {
                this.receiver.batchUpdate(tupleMap.entrySet(), timestamp);
            }
            if (this.container.getTimelyConfiguration().getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL && this.receiver instanceof ResumableNode) {
                ((ResumableNode)((Object)this.receiver)).resumeAt(timestamp);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message selector " + selector);
        }
    }

    public String toString() {
        return "DDF_MBOX (" + this.receiver + ") " + this.getActiveQueue();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.queue.clear();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }
}

