/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.MaskLabelHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.IMaskManagedSemanticParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityElementLabelParser
implements IMaskManagedSemanticParser {
    protected static final String MULTIPLICITY_FORMAT = "[%s..%s]";
    protected static final String MULTIPLICITY_FORMAT_ALT = "[%s]";

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof MultiplicityElement) {
            MultiplicityElement multElt = (MultiplicityElement)eObject;
            if (maskValues.contains("multiplicity")) {
                String upper;
                String lower = multElt.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multElt.getLowerValue(), (boolean)true) : "1";
                String string = upper = multElt.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)multElt.getUpperValue(), (boolean)true) : "1";
                if (maskValues.contains("defaultMultiplicity") || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format(MULTIPLICITY_FORMAT_ALT, lower, upper) : String.format(MULTIPLICITY_FORMAT, lower, upper);
                }
            }
        }
        return result;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return EcorePackage.eINSTANCE.getEAnnotation_Details().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature);
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof MultiplicityElement) {
            MultiplicityElement semElement = (MultiplicityElement)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("multiplicity", "Multiplicity");
        masks.put("defaultMultiplicity", "Show default multiplicity");
        return masks;
    }

    protected Collection<String> getMaskValues(IAdaptable element) {
        View view = (View)element.getAdapter(View.class);
        if (view == null) {
            return this.getDefaultValue(element);
        }
        Collection<String> result = MaskLabelHelper.getMaskValues((View)view);
        if (result == null) {
            result = this.getDefaultValue(element);
        }
        return result;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("multiplicity");
    }
}

