/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackboxRegistry {
    public static final BlackboxRegistry INSTANCE = EMFPlugin.IS_ECLIPSE_RUNNING ? new Eclipse() : new BlackboxRegistry();
    private final StandaloneBlackboxProvider fStandaloneProvider = StandaloneBlackboxProvider.INSTANCE;
    private final List<BlackboxProvider> fProviders = Collections.singletonList(this.fStandaloneProvider);

    protected List<? extends BlackboxProvider> getProviders() {
        return this.fProviders;
    }

    public BlackboxUnitDescriptor getCompilationUnitDescriptor(String qualifiedName, ResolutionContext context) {
        for (BlackboxProvider blackboxProvider : this.getProviders()) {
            BlackboxUnitDescriptor descriptor = blackboxProvider.getUnitDescriptor(qualifiedName, context);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public List<BlackboxUnitDescriptor> getCompilationUnitDescriptors(ResolutionContext loadContext) {
        ArrayList<BlackboxUnitDescriptor> result = new ArrayList<BlackboxUnitDescriptor>();
        for (BlackboxProvider blackboxProvider : this.getProviders()) {
            for (BlackboxUnitDescriptor blackboxUnitDescriptor : blackboxProvider.getUnitDescriptors(loadContext)) {
                result.add(blackboxUnitDescriptor);
            }
        }
        return result;
    }

    public void cleanup() {
        for (BlackboxProvider blackboxProvider : this.getProviders()) {
            blackboxProvider.cleanup();
        }
    }

    public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation operation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (BlackboxProvider blackboxProvider : this.getProviders()) {
            Collection<CallHandler> handlers = blackboxProvider.getBlackboxCallHandler(operation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (BlackboxProvider blackboxProvider : this.getProviders()) {
            Collection<CallHandler> handlers = blackboxProvider.getBlackboxCallHandler(transformation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public void addStandaloneModule(Class<?> cls, String unitQualifiedName, String moduleName, String[] packageURIs) {
        this.fStandaloneProvider.registerDescriptor(cls, unitQualifiedName, moduleName, packageURIs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Eclipse
    extends BlackboxRegistry {
        private static final String CLASS_ATTR = "class";
        private static final String PROVIDER_ELEMENT = "provider";
        private static final String BLACKBOX_PROVIDER_EXTENSION = "blackboxProvider";
        private final List<BlackboxProvider> fProviders = new LinkedList<BlackboxProvider>();

        @Override
        protected List<? extends BlackboxProvider> getProviders() {
            return this.fProviders;
        }

        Eclipse() {
            this.readProviders(this.fProviders);
        }

        private void readProviders(List<BlackboxProvider> providers) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.m2m.qvt.oml", BLACKBOX_PROVIDER_EXTENSION);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    if (element.getName().equals(PROVIDER_ELEMENT)) {
                        Object extension = element.createExecutableExtension(CLASS_ATTR);
                        if (!(extension instanceof BlackboxProvider)) {
                            QvtPlugin.error("Provider must implement AbstractBlackboxProvider interface: " + extension);
                        } else {
                            providers.add((BlackboxProvider)extension);
                        }
                    }
                }
                catch (CoreException e) {
                    QvtPlugin.getDefault().log(e.getStatus());
                }
                catch (RuntimeException e) {
                    QvtPlugin.error(e);
                }
                ++n2;
            }
        }
    }
}

