/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.tableedit;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.jst.pagedesigner.editpolicies.ITableEditAdapter;
import org.eclipse.jst.pagedesigner.tableedit.RowHandle;
import org.eclipse.jst.pagedesigner.tableedit.RowResizeHandle;
import org.eclipse.jst.pagedesigner.tableedit.TableEditHelper;
import org.eclipse.jst.pagedesigner.tableedit.TableRowHandle;

public class TableRowHandleLocator
extends MoveHandleLocator {
    GraphicalEditPart _tablePart;

    public TableRowHandleLocator(GraphicalEditPart tablePart) {
        super(tablePart.getFigure());
        this._tablePart = tablePart;
    }

    public void relocate(IFigure target) {
        Rectangle bounds = this.getReference() instanceof HandleBounds ? ((HandleBounds)this.getReference()).getHandleBounds() : this.getReference().getBounds();
        Insets referenceInsets = this.getReference().getInsets();
        Rectangle r = new Rectangle(bounds.x + bounds.width, bounds.y + referenceInsets.top, 10, bounds.height - referenceInsets.getHeight());
        bounds = new PrecisionRectangle(r);
        this.getReference().translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        target.setBounds(bounds);
        this.relocateChildren(target, this.getReference());
    }

    private void relocateChildren(IFigure target, IFigure reference) {
        TableRowHandle tableRowHandle = (TableRowHandle)target;
        tableRowHandle.removeAll();
        tableRowHandle.setupRows();
        List children = target.getChildren();
        ITableEditAdapter tableAdapter = TableEditHelper.getTableEditAdapter(this._tablePart);
        if (tableAdapter == null) {
            return;
        }
        int i = 0;
        int size = children.size();
        while (i < size) {
            Rectangle rect = null;
            IFigure child = (IFigure)children.get(i);
            if (child instanceof RowHandle) {
                RowHandle rowHandle = (RowHandle)child;
                rowIndex = rowHandle.getIndex();
                rect = new Rectangle(0, tableAdapter.getRowStart(rowIndex), 10, tableAdapter.getRowHeight(rowIndex));
            } else if (child instanceof RowResizeHandle) {
                RowResizeHandle resizeHandle = (RowResizeHandle)child;
                rowIndex = resizeHandle.getRowIndex();
                rect = new Rectangle(0, tableAdapter.getRowResizeStart(rowIndex), 10, tableAdapter.getRowResizeWidth());
            }
            if (rect != null) {
                child.setBounds(rect);
            }
            ++i;
        }
    }
}

