/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCoreTraceOptions;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FaceletChangeDelegate;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FacetChangeModel;
import org.eclipse.jst.jsf.facelet.core.internal.facet.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.facet.WebAppConfigurator;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ViewHandlerType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class FaceletInstallDelegate
extends FaceletChangeDelegate {
    @Override
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        FacetChangeModel model = (FacetChangeModel)config;
        if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
            FaceletCoreTraceOptions.log("Installing facet on project: " + project.getName());
            FaceletCoreTraceOptions.log(String.format("FaceletInstallDelegate: Add default selection %b", model.isChgDefaultSuffix()));
            FaceletCoreTraceOptions.log(String.format("FaceletInstallDelegate: Add view handler %b", model.isChgViewHandler()));
            FaceletCoreTraceOptions.log(String.format("FaceletInstallDelegate: Add configure listener %b", model.isChgConfigureListener()));
            FaceletCoreTraceOptions.log(String.format("FaceletInstallDelegate: Add web app lifecycle listener %b", model.isChgWebAppLifecycleListener()));
        }
        try {
            if (monitor != null) {
                monitor.beginTask("Installing facelet facet", 1);
            }
            super.execute(project, fv, config, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    protected void maybeChangeFaceletViewHandler(IProject project, IProgressMonitor monitor) {
        FacesConfigArtifactEdit edit;
        if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
            FaceletCoreTraceOptions.log("FaceletInstallDelegate: Installing facelet view handler");
        }
        if ((edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)project, (String)"WEB-INF/faces-config.xml")) != null) {
            try {
                FacesConfigType root = edit.getFacesConfig();
                if (!this.isViewHandlerPresent(root)) {
                    if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                        FaceletCoreTraceOptions.log("FaceletInstallDelegate: View Handler not already found in faces-config");
                    }
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new TempSafeUpdateFacesConfigOnUIThread(edit, monitor));
                    if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                        FaceletCoreTraceOptions.log("FaceletInstallDelegate: Saved changes for facelet view handler");
                    }
                } else if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                    FaceletCoreTraceOptions.log("FaceletInstallDelegate: View Handler NOT already found in faces-config; not adding");
                }
            }
            finally {
                edit.dispose();
            }
        }
    }

    @Override
    protected void handleDesignTimeViewHandler(IProject project) {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance((IProject)project);
        manager.setViewHandlerId("org.eclipse.jst.jsf.facelet.core.html.viewhandler");
    }

    @Override
    protected String getDisplayName() {
        return Messages.FaceletInstallDelegate_FACET_INSTALLER_DELEGATE_DISPLAY_NAME;
    }

    @Override
    protected void maybeChangeDefaultSuffix(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgDefaultSuffix()) {
            if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletInstallDelegate: Installing DEFAULT_SUFFIX");
            }
            configurator.addContextParam("javax.faces.DEFAULT_SUFFIX", ".xhtml", false);
        }
    }

    @Override
    protected void maybeChangeConfigureListener(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgConfigureListener()) {
            if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletInstallDelegate: Install Configure Listener");
            }
            configurator.addListener("com.sun.faces.config.ConfigureListener", false);
        }
    }

    @Override
    protected void maybeChangeWebLifecycleListener(FacetChangeModel model, WebAppConfigurator configurator) {
        if (model.isChgWebAppLifecycleListener()) {
            if (FaceletCoreTraceOptions.TRACE_FACETINSTALLDELEGATE) {
                FaceletCoreTraceOptions.log("FaceletInstallDelegate: Install WebappLifecycleListener");
            }
            configurator.addListener("com.sun.faces.application.WebappLifecycleListener", false);
        }
    }

    private static class TempSafeUpdateFacesConfigOnUIThread
    implements Runnable {
        private final FacesConfigArtifactEdit _edit;
        private final IProgressMonitor _monitor;

        public TempSafeUpdateFacesConfigOnUIThread(FacesConfigArtifactEdit edit, IProgressMonitor monitor) {
            this._edit = edit;
            this._monitor = monitor;
        }

        @Override
        public void run() {
            FacesConfigType root = this._edit.getFacesConfig();
            EList applications = root.getApplication();
            ApplicationType application = null;
            if (applications.size() > 0) {
                application = (ApplicationType)applications.get(0);
            } else {
                application = FacesConfigFactory.eINSTANCE.createApplicationType();
                applications.add((Object)application);
            }
            ViewHandlerType viewHandlerType = FacesConfigFactory.eINSTANCE.createViewHandlerType();
            viewHandlerType.setTextContent("com.sun.facelets.FaceletViewHandler");
            application.getViewHandler().add((Object)viewHandlerType);
            this._edit.save(this._monitor);
        }
    }
}

