/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.internal.nodes;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.StaticAnchor;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.fx.utils.Geometry2Shape;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;

public class Traverse
extends Group
implements IBendableCurve<Polyline, Shape> {
    private static final String START_ROLE = "start";
    private static final String END_ROLE = "end";
    private Polyline curve = new Polyline(new double[]{0.0, 0.0, 0.0, 0.0});
    private ObservableList<Point> points = CollectionUtils.observableArrayList((Object[])new Point[]{new Point(), new Point()});
    private ObjectProperty<Shape> startDecorationProperty = null;
    private ObjectProperty<Shape> endDecorationProperty = null;
    private AnchorKey startAnchorKey = new AnchorKey((Node)this.curve, "start");
    private AnchorKey endAnchorKey = new AnchorKey((Node)this.curve, "end");
    private Map<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>> anchorsPCL = new HashMap<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>>();
    private AnchorMap anchorsByKeys = new AnchorMap();
    private ChangeListener<Node> decorationListener = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
            Traverse.this.refreshChildren();
            Traverse.this.refreshDecorations();
        }
    };
    private ChangeListener<Transform> transformListener = new ChangeListener<Transform>(){

        public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
            Traverse.this.refreshDecorations();
        }
    };
    private ChangeListener<Bounds> boundsListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
            Traverse.this.refreshDecorations();
        }
    };
    private DoubleProperty clickableAreaWidth = new SimpleDoubleProperty();
    private Polyline clickableAreaShape = null;
    private ListChangeListener<Double> coordinatesListener = new ListChangeListener<Double>(){

        public void onChanged(ListChangeListener.Change<? extends Double> c) {
            throw new IllegalStateException("Direct manipulation of the curve's (Polyline) coordinates are not supported. Manipulate the points of the Traverse instead; the coordinates will get updated as a consequence.");
        }
    };

    public Traverse() {
        this.setAutoSizeChildren(false);
        this.getChildren().add((Object)this.curve);
        this.curve.layoutBoundsProperty().addListener(this.boundsListener);
        this.curve.localToParentTransformProperty().addListener(this.transformListener);
        this.curve.getPoints().addListener(this.coordinatesListener);
        this.setStartPoint(new Point());
        this.setEndPoint(new Point());
        this.clickableAreaWidth.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Polyline curve = Traverse.this.getCurve();
                if (newValue != null && newValue.doubleValue() > curve.getStrokeWidth() && Traverse.this.clickableAreaShape == null) {
                    Traverse.this.clickableAreaShape = new Polyline();
                    Traverse.this.clickableAreaShape.getPoints().addAll((Collection)curve.getPoints());
                    Traverse.this.clickableAreaShape.setId("clickable area of GeometryNode " + this);
                    Traverse.this.clickableAreaShape.setStroke((Paint)Color.TRANSPARENT);
                    Traverse.this.clickableAreaShape.setMouseTransparent(false);
                    Traverse.this.clickableAreaShape.strokeWidthProperty().bind((ObservableValue)Traverse.this.clickableAreaWidthProperty());
                } else if ((newValue == null || newValue.doubleValue() <= curve.getStrokeWidth()) && Traverse.this.clickableAreaShape != null) {
                    Traverse.this.clickableAreaShape.strokeWidthProperty().unbind();
                    Traverse.this.clickableAreaShape = null;
                }
                Traverse.this.refreshChildren();
            }
        });
    }

    @Override
    public void addControlPoint(int index, Point controlPoint) {
        if (controlPoint == null) {
            throw new IllegalArgumentException("controlPoint may not be null.");
        }
        this.points.add(index + 1, (Object)controlPoint);
        Point p = NodeUtils.parentToLocal((Node)this.curve, controlPoint);
        this.addCurveCoordinates(2 * (index + 1), p.x, p.y);
    }

    private void addCurveCoordinates(int index, Double ... coordinates) {
        this.curve.getPoints().removeListener(this.coordinatesListener);
        this.curve.getPoints().addAll(index, Arrays.asList(coordinates));
        this.curve.getPoints().addListener(this.coordinatesListener);
    }

    private void arrangeDecoration(Node decoration, Point offset, Vector direction) {
        AffineTransform transform = new AffineTransform().translate(offset.x, offset.y);
        if (!direction.isNull()) {
            Angle angleCW = new Vector(1.0, 0.0).getAngleCW(direction);
            transform.rotate(angleCW.rad(), 0.0, 0.0);
        }
        transform.translate(-NodeUtils.getShapeBounds(decoration).getX(), 0.0);
        decoration.getTransforms().setAll((Object[])new Transform[]{Geometry2FX.toFXAffine((AffineTransform)transform)});
    }

    @Override
    public DoubleProperty clickableAreaWidthProperty() {
        return this.clickableAreaWidth;
    }

    private Shape clipAtDecoration(Shape curveShape, Shape curveClip, Shape decoration) {
        Path decorationShapeBounds = new Path(Geometry2Shape.toPathElements(NodeUtils.localToScene((Node)decoration, (IGeometry)NodeUtils.getShapeBounds((Node)decoration)).toPath()));
        decorationShapeBounds.setFill((Paint)Color.RED);
        Shape clip = Shape.intersect((Shape)decorationShapeBounds, (Shape)curveShape);
        clip = Shape.subtract((Shape)clip, (Shape)decoration);
        clip = Shape.subtract((Shape)curveClip, (Shape)clip);
        return clip;
    }

    protected MapChangeListener<? super AnchorKey, ? super Point> createPCL(final AnchorKey anchorKey) {
        return new MapChangeListener<AnchorKey, Point>(){

            public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
                if (((AnchorKey)change.getKey()).equals(anchorKey) && change.wasAdded() && change.wasRemoved()) {
                    Traverse.this.updateCurve((AnchorKey)change.getKey());
                    Traverse.this.refreshDynamicAnchors();
                }
            }
        };
    }

    public ObjectProperty<Shape> endDecorationProperty() {
        if (this.endDecorationProperty == null) {
            this.endDecorationProperty = new SimpleObjectProperty();
            this.endDecorationProperty.addListener(this.decorationListener);
        }
        return this.endDecorationProperty;
    }

    @Override
    public double getClickableAreaWidth() {
        return this.clickableAreaWidth.get();
    }

    @Override
    public Point getControlPoint(int index) {
        return (Point)this.points.get(index + 1);
    }

    @Override
    public List<Point> getControlPoints() {
        return this.points.subList(1, this.points.size() - 1);
    }

    @Override
    public Polyline getCurve() {
        return this.curve;
    }

    @Override
    public IAnchor getEndAnchor() {
        return this.anchorsByKeys.get(this.endAnchorKey);
    }

    @Override
    public Shape getEndDecoration() {
        if (this.endDecorationProperty == null) {
            return null;
        }
        return (Shape)this.endDecorationProperty.get();
    }

    @Override
    public Point getEndPoint() {
        return (Point)this.points.get(this.points.size() - 1);
    }

    @Override
    public Point getPoint(int index) {
        return (Point)this.points.get(index);
    }

    @Override
    public ObservableList<Point> getPointsUnmodifiable() {
        return FXCollections.unmodifiableObservableList(this.points);
    }

    @Override
    public IAnchor getStartAnchor() {
        return this.anchorsByKeys.get(this.startAnchorKey);
    }

    @Override
    public Shape getStartDecoration() {
        if (this.startDecorationProperty == null) {
            return null;
        }
        return (Shape)this.startDecorationProperty.get();
    }

    @Override
    public Point getStartPoint() {
        return (Point)this.points.get(0);
    }

    private boolean isConnected(IAnchor anchor) {
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    @Override
    public boolean isEndConnected() {
        return this.isConnected(this.getEndAnchor());
    }

    @Override
    public boolean isStartConnected() {
        return this.isConnected(this.getStartAnchor());
    }

    public double maxHeight(double width) {
        return Double.MAX_VALUE;
    }

    public double maxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public double minHeight(double width) {
        return 0.0;
    }

    public double minWidth(double height) {
        return 0.0;
    }

    private void refreshChildren() {
        Shape endDecoration;
        this.getChildren().retainAll((Object[])new Node[]{this.curve});
        Shape startDecoration = this.getStartDecoration();
        if (startDecoration != null) {
            this.getChildren().add((Object)startDecoration);
        }
        if ((endDecoration = this.getEndDecoration()) != null) {
            this.getChildren().add((Object)endDecoration);
        }
        if (this.clickableAreaShape != null) {
            this.getChildren().add((Object)this.clickableAreaShape);
        }
    }

    protected void refreshClip() {
        Shape startDecoration = this.getStartDecoration();
        Shape endDecoration = this.getEndDecoration();
        if (startDecoration != null || endDecoration != null) {
            Bounds visualBounds = this.curve.localToScene(Geometry2FX.toFXBounds((Rectangle)NodeUtils.getShapeBounds((Node)this.curve)));
            javafx.scene.shape.Rectangle clip = new javafx.scene.shape.Rectangle(visualBounds.getMinX(), visualBounds.getMinY(), visualBounds.getWidth(), visualBounds.getHeight());
            clip.setFill((Paint)Color.RED);
            if (startDecoration != null) {
                clip = this.clipAtDecoration((Shape)this.curve, (Shape)clip, startDecoration);
            }
            if (endDecoration != null) {
                clip = this.clipAtDecoration((Shape)this.curve, (Shape)clip, endDecoration);
            }
            AffineTransform sceneToLocalTx = NodeUtils.getSceneToLocalTx((Node)this.curve);
            clip.getTransforms().add((Object)Geometry2FX.toFXAffine((AffineTransform)sceneToLocalTx));
            this.curve.setClip((Node)clip);
        } else {
            this.curve.setClip(null);
        }
    }

    protected void refreshDecorations() {
        Shape endDecoration;
        Double[] coordinates = (Double[])this.curve.getPoints().toArray((Object[])new Double[0]);
        if (coordinates.length < 4) {
            return;
        }
        Shape startDecoration = this.getStartDecoration();
        if (startDecoration != null) {
            Point startPoint = new Point(coordinates[0].doubleValue(), coordinates[1].doubleValue());
            Point refPoint = new Point(coordinates[2].doubleValue(), coordinates[3].doubleValue());
            Vector startDirection = new Vector(startPoint, refPoint);
            this.arrangeDecoration((Node)startDecoration, startPoint, startDirection);
        }
        if ((endDecoration = this.getEndDecoration()) != null) {
            Point endPoint = new Point(coordinates[coordinates.length - 2].doubleValue(), coordinates[coordinates.length - 1].doubleValue());
            Point refPoint = new Point(coordinates[coordinates.length - 4].doubleValue(), coordinates[coordinates.length - 3].doubleValue());
            Vector endDirection = new Vector(endPoint, refPoint);
            this.arrangeDecoration((Node)endDecoration, endPoint, endDirection);
        }
        this.refreshClip();
    }

    protected void refreshDynamicAnchors() {
        if (this.anchorsByKeys.size() < 2) {
            return;
        }
        int i = 0;
        while (i < 2) {
            AnchorKey anchorKey;
            IAnchor anchor = this.anchorsByKeys.get(i);
            AnchorKey anchorKey2 = anchorKey = i == 0 ? this.startAnchorKey : this.endAnchorKey;
            if (anchor instanceof DynamicAnchor) {
                DynamicAnchor.AnchoredReferencePoint anchoredReferencePoint;
                ObservableList coordinates = this.curve.getPoints();
                Point refPoint = null;
                if (coordinates.size() == 4) {
                    AnchorKey oppositeAnchorKey = i == 0 ? this.endAnchorKey : this.startAnchorKey;
                    IAnchor oppositeAnchor = this.anchorsByKeys.get(oppositeAnchorKey);
                    Node oppositeAnchorage = oppositeAnchor.getAnchorage();
                    if (oppositeAnchor instanceof DynamicAnchor && oppositeAnchorage != null) {
                        refPoint = NodeUtils.sceneToLocal((Node)this.curve, NodeUtils.localToScene(oppositeAnchorage, NodeUtils.getShapeBounds(oppositeAnchorage).getCenter()));
                    }
                }
                if (refPoint == null) {
                    int refCoordinatesIndex = i == 0 ? 2 : coordinates.size() - 4;
                    refPoint = new Point(((Double)coordinates.get(refCoordinatesIndex)).doubleValue(), ((Double)coordinates.get(refCoordinatesIndex + 1)).doubleValue());
                }
                if (!refPoint.equals((anchoredReferencePoint = ((DynamicAnchor)anchor).getComputationParameter(anchorKey, DynamicAnchor.AnchoredReferencePoint.class)).get())) {
                    anchoredReferencePoint.set(refPoint);
                    this.updateCurve(anchorKey);
                }
            }
            ++i;
        }
    }

    private void registerPCL(AnchorKey anchorKey, IAnchor anchor) {
        if (!this.anchorsPCL.containsKey(anchorKey)) {
            MapChangeListener<? super AnchorKey, ? super Point> pcl = this.createPCL(anchorKey);
            this.anchorsPCL.put(anchorKey, pcl);
            anchor.positionsUnmodifiableProperty().addListener(pcl);
        }
    }

    public void removeAllControlPoints() {
        this.points.remove(1, this.points.size() - 1);
        this.removeCoordinates(2, this.curve.getPoints().size() - 2);
    }

    @Override
    public void removeControlPoint(int index) {
        this.points.remove(index + 1);
        this.removeCoordinates(2 * (index + 1), 2 * (index + 1) + 2);
    }

    private void removeCoordinates(int from, int to) {
        ObservableList coordinates = this.curve.getPoints();
        coordinates.removeListener(this.coordinatesListener);
        coordinates.remove(from, to);
        coordinates.addListener(this.coordinatesListener);
    }

    private void setAllCoordinates(Double ... coordinates) {
        ObservableList points = this.curve.getPoints();
        if (this.coordinatesListener != null) {
            points.removeListener(this.coordinatesListener);
        }
        points.setAll((Object[])coordinates);
        if (this.coordinatesListener != null) {
            points.addListener(this.coordinatesListener);
        }
    }

    protected IAnchor setAnchor(AnchorKey anchorKey, IAnchor anchor) {
        if (anchorKey == null) {
            throw new IllegalArgumentException("anchorKey may not be null.");
        }
        if (anchorKey.getAnchored() != this.curve) {
            throw new IllegalArgumentException("anchorKey may only be anchored to curveProperty node");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        IAnchor oldAnchor = this.anchorsByKeys.set(anchorKey, anchor);
        this.unregisterPCL(anchorKey, oldAnchor);
        if (oldAnchor != null) {
            this.unregisterPCL(anchorKey, oldAnchor);
            oldAnchor.detach(anchorKey);
        }
        anchor.attach(anchorKey);
        this.updateCurve(anchorKey);
        this.registerPCL(anchorKey, anchor);
        this.refreshDynamicAnchors();
        return anchor;
    }

    @Override
    public void setClickableAreaWidth(double clickableAreaWidth) {
        this.clickableAreaWidth.set(clickableAreaWidth);
    }

    @Override
    public void setControlPoint(int index, Point controlPoint) {
        if (this.getStartAnchor() == null || this.getEndAnchor() == null) {
            throw new IllegalStateException("Curve does not have start and end.");
        }
        if (!controlPoint.equals(this.points.get(index + 1))) {
            this.points.set(index + 1, (Object)controlPoint);
        }
        Point p = NodeUtils.parentToLocal((Node)this.curve, controlPoint);
        this.setCoordinates(2 * (index + 1), p.x, p.y);
    }

    @Override
    public void setControlPoints(List<Point> controlPoints) {
        if (this.anchorsByKeys.size() != 2) {
            throw new IllegalStateException("Curve does not have start and end.");
        }
        Double[] coordinates = new Double[2 * controlPoints.size() + 4];
        ArrayList<Point> points = new ArrayList<Point>();
        ObservableList curvePoints = this.curve.getPoints();
        coordinates[0] = (Double)curvePoints.get(0);
        coordinates[1] = (Double)curvePoints.get(1);
        points.add((Point)this.points.get(0));
        int i = 0;
        while (i < controlPoints.size()) {
            Point cp = controlPoints.get(i);
            points.add(cp);
            Point p = NodeUtils.parentToLocal((Node)this.curve, cp);
            coordinates[2 * (i + 1)] = p.x;
            coordinates[2 * (i + 1) + 1] = p.y;
            ++i;
        }
        coordinates[coordinates.length - 2] = (Double)curvePoints.get(curvePoints.size() - 2);
        coordinates[coordinates.length - 1] = (Double)curvePoints.get(curvePoints.size() - 1);
        points.add((Point)this.points.get(this.points.size() - 1));
        this.points.setAll(points);
        this.setAllCoordinates(coordinates);
    }

    private void setCoordinates(int index, Double ... coordinates) {
        ObservableList points = this.curve.getPoints();
        if (this.coordinatesListener != null) {
            this.curve.getPoints().removeListener(this.coordinatesListener);
        }
        if (index + coordinates.length > points.size()) {
            Double[] coords = new Double[Math.max(index + coordinates.length, points.size())];
            int i = 0;
            while (i < index) {
                coords[i] = (Double)points.get(i);
                ++i;
            }
            while (i < index + coordinates.length) {
                coords[i] = coordinates[i - index];
                ++i;
            }
            while (i < points.size()) {
                coords[i] = (Double)points.get(i);
                ++i;
            }
            points.setAll(Arrays.asList(coords));
        } else {
            int i = 0;
            while (i < coordinates.length) {
                if (points.get(index + i) != coordinates[i]) {
                    points.set(index + i, (Object)coordinates[i]);
                }
                ++i;
            }
        }
        if (this.coordinatesListener != null) {
            this.curve.getPoints().addListener(this.coordinatesListener);
        }
    }

    @Override
    public void setEndAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        this.setAnchor(this.endAnchorKey, anchor);
    }

    @Override
    public void setEndDecoration(Shape decoration) {
        this.endDecorationProperty().set((Object)decoration);
    }

    @Override
    public void setEndPoint(Point endPoint) {
        if (endPoint == null) {
            throw new IllegalArgumentException("endPoint may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, endPoint);
        this.setEndAnchor(anchor);
    }

    @Override
    public void setPoints(List<Point> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points have to be provided.");
        }
        this.setStartPoint(points.get(0));
        if (points.size() > 2) {
            this.setControlPoints(points.subList(1, points.size() - 1));
        } else {
            this.removeAllControlPoints();
        }
        this.setEndPoint(points.get(points.size() - 1));
    }

    @Override
    public void setStartAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        this.setAnchor(this.startAnchorKey, anchor);
    }

    @Override
    public void setStartDecoration(Shape decoration) {
        this.startDecorationProperty().set((Object)decoration);
    }

    @Override
    public void setStartPoint(Point startPoint) {
        if (startPoint == null) {
            throw new IllegalArgumentException("startPoint may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, startPoint);
        this.setStartAnchor(anchor);
    }

    public ObjectProperty<Shape> startDecorationProperty() {
        if (this.startDecorationProperty == null) {
            this.startDecorationProperty = new SimpleObjectProperty();
            this.startDecorationProperty.addListener(this.decorationListener);
        }
        return this.startDecorationProperty;
    }

    private void unregisterPCL(AnchorKey anchorKey, IAnchor anchor) {
        if (this.anchorsPCL.containsKey(anchorKey)) {
            anchor.positionsUnmodifiableProperty().removeListener(this.anchorsPCL.remove(anchorKey));
        }
    }

    private void updateCurve(AnchorKey anchorKey) {
        IAnchor anchor = this.anchorsByKeys.get(anchorKey);
        int index = anchorKey == this.startAnchorKey ? 0 : this.curve.getPoints().size() / 2 - 1;
        Point point = anchor.getPosition(anchorKey);
        Point p = NodeUtils.localToParent((Node)this.curve, point);
        if (!p.equals(this.points.get(index))) {
            this.points.set(index, (Object)p);
        }
        this.setCoordinates(2 * index, point.x, point.y);
    }

    private class AnchorMap {
        private List<AnchorKey> anchorKeys = new ArrayList<AnchorKey>();
        private TreeMap<AnchorKey, IAnchor> anchorsByKeys = new TreeMap(new Comparator<AnchorKey>(){

            @Override
            public int compare(AnchorKey o1, AnchorKey o2) {
                if (o1.getId().equals(o2.getId())) {
                    return 0;
                }
                if (Traverse.START_ROLE.equals(o1.getId())) {
                    return -1;
                }
                if (Traverse.END_ROLE.equals(o1.getId())) {
                    return 1;
                }
                if (Traverse.START_ROLE.equals(o2.getId())) {
                    return 1;
                }
                if (Traverse.END_ROLE.equals(o2.getId())) {
                    return -1;
                }
                return Integer.parseInt(o1.getId()) - Integer.parseInt(o2.getId());
            }
        });
        private ObservableList<IAnchor> anchors = CollectionUtils.observableArrayList();

        private AnchorMap() {
        }

        IAnchor get(AnchorKey anchorKey) {
            return this.anchorsByKeys.get(anchorKey);
        }

        IAnchor get(int index) {
            if (this.anchorKeys.isEmpty()) {
                Iterables.addAll(this.anchorKeys, this.anchorsByKeys.keySet());
            }
            return (IAnchor)this.anchors.get(index);
        }

        int getIndex(AnchorKey anchorKey) {
            if (this.anchorKeys.isEmpty()) {
                Iterables.addAll(this.anchorKeys, this.anchorsByKeys.keySet());
            }
            return this.anchorKeys.indexOf(anchorKey);
        }

        IAnchor set(AnchorKey key, IAnchor anchor) {
            this.anchorKeys.clear();
            IAnchor oldAnchor = this.anchorsByKeys.put(key, anchor);
            int index = this.getIndex(key);
            if (this.anchorKeys.size() > this.anchors.size()) {
                this.anchors.add(index, (Object)anchor);
            } else {
                this.anchors.set(index, (Object)anchor);
            }
            return oldAnchor;
        }

        int size() {
            return this.anchors.size();
        }
    }
}

