/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;

public class VariableInitializationChecker
extends AbstractIndexAstChecker {
    public static final String STATIC_VAR_ID = "org.eclipse.cdt.codan.internal.checkers.StaticVariableInHeaderProblem";
    public static final String VAR_MULTI_DEC_ID = "org.eclipse.cdt.codan.internal.checkers.MultipleDeclarationsProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                if (declaration instanceof IASTSimpleDeclaration) {
                    IASTNode node;
                    IASTSimpleDeclaration simple = (IASTSimpleDeclaration)declaration;
                    IASTDeclarator[] decls = ((IASTSimpleDeclaration)declaration).getDeclarators();
                    if (simple.getDeclSpecifier().getStorageClass() == 3 && declaration.getTranslationUnit().isHeaderUnit()) {
                        IASTDeclarator[] iASTDeclaratorArray = decls;
                        int n = decls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTDeclarator d = iASTDeclaratorArray[n2];
                            IBinding binding = d.getName().resolveBinding();
                            if (binding != null && binding instanceof IVariable) {
                                IScope scope;
                                block11: {
                                    scope = binding.getScope();
                                    if (scope != null) break block11;
                                    return 3;
                                }
                                try {
                                    if (scope.getKind() == EScopeKind.eGlobal || scope.getKind() == EScopeKind.eNamespace) {
                                        VariableInitializationChecker.this.reportProblem(VariableInitializationChecker.STATIC_VAR_ID, (IASTNode)declaration, new Object[]{d.getName()});
                                    }
                                }
                                catch (DOMException e) {
                                    CodanCheckersActivator.log(e);
                                }
                            }
                            ++n2;
                        }
                    }
                    if (declaration.getParent() instanceof IASTDeclarationStatement && ((node = declaration.getParent().getParent()) instanceof IASTForStatement || node instanceof IASTIfStatement || node instanceof IASTSwitchStatement)) {
                        return 3;
                    }
                    if (decls.length == 0) {
                        return 3;
                    }
                    if (decls.length != 1) {
                        VariableInitializationChecker.this.reportProblem(VariableInitializationChecker.VAR_MULTI_DEC_ID, (IASTNode)declaration, new Object[0]);
                    }
                }
                return 3;
            }
        });
    }
}

