/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.Preference;
import org.mandas.docker.client.messages.swarm.Spread;

final class ImmutablePreference
implements Preference {
    private final Spread spread;

    private ImmutablePreference(Spread spread) {
        this.spread = spread;
    }

    @Override
    @JsonProperty(value="Spread")
    public Spread spread() {
        return this.spread;
    }

    public final ImmutablePreference withSpread(Spread value) {
        if (this.spread == value) {
            return this;
        }
        Spread newValue = Objects.requireNonNull(value, "spread");
        return new ImmutablePreference(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreference && this.equalTo(0, (ImmutablePreference)another);
    }

    private boolean equalTo(int synthetic, ImmutablePreference another) {
        return this.spread.equals(another.spread);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.spread.hashCode();
        return h;
    }

    public String toString() {
        return "Preference{spread=" + this.spread + "}";
    }

    public static ImmutablePreference copyOf(Preference instance) {
        if (instance instanceof ImmutablePreference) {
            return (ImmutablePreference)instance;
        }
        return ImmutablePreference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_SPREAD = 1L;
        private long initBits = 1L;
        private Spread spread;

        private Builder() {
        }

        public final Builder from(Preference instance) {
            Objects.requireNonNull(instance, "instance");
            this.spread(instance.spread());
            return this;
        }

        @JsonProperty(value="Spread")
        public final Builder spread(Spread spread) {
            this.spread = Objects.requireNonNull(spread, "spread");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePreference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreference(this.spread);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spread");
            }
            return "Cannot build Preference, some of required attributes are not set " + attributes;
        }
    }
}

